var Service = require('Service');
var util = require('util');
var utils = require('utils');
var DepDao = require('../../dao/dep');

/**
 * 准备修改部门信息
 */
var PreUpdate = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(PreUpdate, Service);

module.exports = PreUpdate;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PreUpdate.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供部门编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的部门编号！');
    return;
  }
  var self = this;
  var dao = new DepDao(this);
  dao.query({where:'id='+req.id+' and org_id='+req.session.orgId}, function(deps) {
  	if(deps.length==0) {
  		self.onLogicError(2, '请提供正确的部门编号！');
      return;
  	}
	  res.dep = deps[0];
	  if(res.dep.parent_id==0) {
  	  self.end(res);
  	  return;
	  }
	  req.session.cache.get("dep", res.dep.parent_id, function(err2, depParent){
	  	if(err2) {
		    self.onLogicError(3, err.message);
		    return;
		  }
		  res.dep.parentDep = {
		  	id : depParent.id,
		  	name : depParent.name
		  };
		  self.end(res);
		});
  });
};