var Service = require('Service');
var utils = require('utils');
var Dep = require('../../dao/dep');
var util = require('util');

/**
 * 获得部门列表
 */
var GetListAll = function () {
  Service.call(this);
  this.connectDb = false;
};

util.inherits(GetListAll, Service);

module.exports = GetListAll;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetListAll.prototype.process = function (req, res) {
  var self = this;
  var name = 'dep';
  var fields = 'id,code,name,parent_id';
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    name = 'mdep';
    fields = 'id,org_id,code,name,company_sign,external_sign,parent_id,company_id,parent_ids';
  }
  req.session.cache.getList(name, { fields: fields }, function (err, deps) {
    if (err) {
      self.onLogicError(1, err.message, req, res);
      return;
    }
    res.deps = deps;
	/*res.deps = { fields: ["id", "name", "parent_id"], data: [] };
    for(var i=0;i<deps.length;i++) {
      let dep = deps[i];
      res.deps.data.push([dep.id, dep.name, dep.parent_id]);
    }*/
    self.end(res);
  });
};