var Service = require('Service');
var util = require('util');
var utils = require('utils');
var DepDao = require('../../dao/dep');

/**
 * 获得部门列表
 */
var GetList = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(GetList, Service);

module.exports = GetList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetList.prototype.process =  function(req, res) {
  var parent_id = 0;
  if(req.parentId && utils.isInt(req.parentId)) parent_id = parseInt(req.parentId);
  var self = this;
  var depDao = new DepDao(this);
  depDao.query({
  	fields: 'id,code,name,fullname,description,parent_id',
    where: 'parent_id='+parent_id+' and org_id='+req.session.orgId+' and status=0'
  }, function(rows) { 	
    res.deps = rows;
    self.end(res);
  });
};