var Service = require('Service');
var util = require('util');
var DepDao = require('../../dao/dep');

/**
 * 获得部门列表
 */
var GetByCode = function () {
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(GetByCode, Service);

module.exports = GetByCode;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetByCode.prototype.process = function (req, res) {
  if (!req.code) {
    this.onLogicError(1, '请提供部门代码！');
    return;
  }

  var self = this;
  var depDao = new DepDao(this);
  depDao.query({
    fields: 'id,code,name,fullname,description,parent_id',
    where: 'code=\'' + req.code + '\' and org_id=' + req.session.orgId + ' and status=0'
  }, function (rows) {
    if (rows.length == 0) {
      self.onLogicError(2, '请提供正确的部门代码！');
      return;
    }
    res.dep = rows[0];
    self.end(res);
  });
};