var Service = require('Service');
var utils = require('utils');
var Dep_User = require('../../dao/dep_user');
var Org = require('../../dao/org');
var util = require('util');

/**
 * 删除用户
 */
var DeleteUser = function () {
  Service.call(this);
};

util.inherits(DeleteUser, Service);

module.exports = DeleteUser;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
DeleteUser.prototype.process = function (req, res, cb) {
  if (!req.depId) {
    this.onLogicError(1, '请提供部门编号！', req, res, cb);
    return;
  }
  if (!utils.isInt(req.depId)) {
    this.onLogicError(2, '请提供正确的部门编号！', req, res, cb);
    return;
  }
  if (!req.userIdList) {
    this.onLogicError(3, '请提供用户编号！', req, res, cb);
    return;
  }
  var arrUserId = utils.strToIntArray(req.userIdList);
  if (arrUserId.length == 0) {
    this.onLogicError(4, '请提供正确的用户编号！', req, res, cb);
    return;
  }

  var self = this;
  var dao = new Dep_User(this);
  dao.delete('dep_id=' + req.depId + ' and user_id in (' + req.userIdList + ') and org_id=' + req.session.orgId, function () {
    var orgDao = new Org(self);
    orgDao.setLastUpdate(req.session.orgId, function (lastUpdate) {
      self.requestIMService('sys/service/cache/deleteDepUser', {
        depId: req.depId,
        userIdList: req.userIdList
      }, req, function (resIM) {
        if (resIM.code != 0) {
          self.onError(resIM);
          return;
        }
        if (cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      });
    });
  });
};