var Service = require('Service');
var utils = require('utils');
var Dep = require('../../dao/dep');
var Org = require('../../dao/org');
var DepUser = require('../../dao/dep_user');
var util = require('util');

/**
 * 修改部门信息
 */
var Delete = function() { 
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process =  function(req, res, cb) {
  if(!req.id) {
    this.onLogicError(1, '请提供部门编号！', req, res, cb);
    return;
  }

  var self = this;

  /*req.session.cache.getList("dep", null, function(err, deps){
    res.deps = deps;
    self.end(res);
  });
  return;*/

  var ids = utils.strToIntArray(req.id);
  if(ids.length==0) {
    this.onLogicError(1, '请提供部门编号！', req, res, cb);
    return;
  }
  ids = ids.join();
  if(req.childs) {
    var childs = utils.strToIntArray(req.childs);
    if(childs.length>0) ids += ','+childs.join();
  }
  
  req.session.cache.getList("dep", "["+ids+"].contains(#{id}) "
    +"&& (#{users}.length>0 || #{subDeps}.length>0)", function(err, deps){
    if(err) {
      self.onLogicError(2, err.message);
      return;
    }
    if(deps.length>0) {
      self.onLogicError(3, '部门内还有子部门或用户，目前不能删除！', req, res, cb);
      return;
    }
    var dao = new Dep(self);
    dao.update({status: 1}, {where: 'id in ('+ids+') and org_id='+req.session.orgId}, function() {
      var orgDao = new Org(self);
      orgDao.setLastUpdate(req.session.orgId, function(lastUpdate) { 
        req.session.cache.del("dep", "["+ids+"].contains(#{id})", function(err2) {
          if(err2) {
            self.onLogicError(4, err2.message);
            return;
          }
          if(cb) {
            cb(req, res);
          } else {
            self.end(res);
          }
        });
      });
    });
  });
};