var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 
 */
var Update = function () {
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(Update, Service);

module.exports = Update;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Update.prototype.process = function (req, res) {
  //请求参数校验
  if (utils.isNull(req.id)) {
    this.onLogicError(1, '请提供参数[id]！');
    return;
  }
  if (!utils.isNull(req.id) && !utils.isInt(req.id)) {
    this.onLogicError(2, '参数[id]格式不正确！');
    return;
  }

  var self = this;
  let obj = {};
  if (!utils.isNull(req.title)) obj['title'] = req.title + "";
  if (!utils.isNull(req.username)) obj['username'] = req.username + "";
  if (!utils.isNull(req.runtime)) obj['runtime'] = req.runtime + "";
  if (!utils.isNull(req.c_text)) obj['c_text'] = req.c_text + "";
  if (!utils.isNull(req.c_password)) obj['c_password'] = req.c_password + "";
  if (!utils.isNull(req.c_textarea)) obj['c_textarea'] = req.c_textarea + "";
  if (!utils.isNull(req.c_switch)) obj['c_switch'] = req.c_switch + "";
  if (!utils.isNull(req.c_radio)) obj['c_radio'] = req.c_radio + "";
  if (!utils.isNull(req.c_checkbox)) obj['c_checkbox'] = req.c_checkbox + "";
  if (!utils.isNull(req.c_select)) obj['c_select'] = req.c_select + "";
  if (!utils.isNull(req.c_date)) obj['c_date'] = req.c_date + "";
  if (!utils.isNull(req.c_time)) obj['c_time'] = req.c_time + "";
  if (!utils.isNull(req.c_pre)) obj['c_pre'] = req.c_pre + "";
  if (!utils.isNull(req.c_label)) obj['c_label'] = req.c_label + "";

  let options = {
    where: "id=?",
    params: [req.id]
  };
  self._dao.model = server.loadModule('/app/sys/model/sys_demo.json');
  self._dao.update(obj, options, function () {
    self.end(res);
  });
};
