var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 
 */
var Page = function () {
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(Page, Service);

module.exports = Page;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
 Page.prototype.process = function (req, res) {
  var self = this;
  let params = [];
  let where = "";
  if (!utils.isNull(req.title)) {
    where += "title like ?";
    params.push("%" + req.title + "%");
  }

  if (where == "") where = " 1=1 ";
  options = {
    sql: "select * from sys_demo where " + where + "",
    params: params,
    count_sql: "select count(*) as count_ from (select * from sys_demo where " + where + ") count_rows ",
    count_params: params,
    order: "id asc"
  };
  self._dao.queryDataPage(req, options, function (rows) {
    res.data = rows;
    self.end(res);
  });
};
