var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 
 */
var List = function () {
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(List, Service);

module.exports = List;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
List.prototype.process = function (req, res) {
  var self = this;
  let params = [];
  let where = "";
  if (!utils.isNull(req.title)) {
    where += "title like ?";
    params.push("%" + req.title + "%");
  }

  if (where == "") where = " 1=1 ";
  options = {
    sql: "select * from sys_demo where " + where + "",
    params: params,
    order: "id asc"
  };
  self._dao.query(options, function (rows) {
    res.data = rows;
    self.end(res);
  });
};
