var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 
 */
var Get = function () {
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process = function (req, res, cb) {
  //请求参数校验
  if (utils.isNull(req.id)) {
    this.onLogicError(1, '请提供参数[id]！');
    return;
  }
  if (!utils.isNull(req.id) && !utils.isInt(req.id)) {
    this.onLogicError(2, '参数[id]格式不正确！');
    return;
  }

  var self = this;
  let params = [];
  params.push(req.id);
  self._dao.execute("select * from sys_demo where id=? ", params, function (rows) {
    res.data = rows[0];
    self.end(res);
  });
};