var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 
 */
var Delete = function () {
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Delete.prototype.process = function (req, res) {
  //请求参数校验
  if (utils.isNull(req.id)) {
    this.onLogicError(1, '请提供参数[id]！');
    return;
  }
  if (!utils.isNull(req.id) && !utils.isInt(req.id)) {
    this.onLogicError(2, '参数[id]格式不正确！');
    return;
  }

  var self = this;
  let params = [req.id];
  self._dao.execute("delete from sys_demo where id=?", params, function () {
    self.end(res);
  });
};
