var Service = require('Service');
var util = require('util');
var utils = require('utils');

/**
 * 修改数据源信息
 */
var UpdateDataSource = function () {
    Service.call(this);
  this.sqlInject = {check: false};
};

util.inherits(UpdateDataSource, Service);

module.exports = UpdateDataSource;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateDataSource.prototype.process = function (req, res) {
    if (!req.id) {
        this.onLogicError(1, '请提供数据源ID！', req, res);
        return;
    }
    if (!req.name) {
        this.onLogicError(2, '请提供数据源名称！', req, res);
        return;
    }
    if (!req.type) {
        this.onLogicError(3, '请提供数据源类型！', req, res);
        return;
    }
    if (req.type == 'sqlite') {
        if (!req.filePath) {
            this.onLogicError(4, '请提供文件路径！', req, res);
            return;
        }
    }
    else {
        if (!req.host) {
            this.onLogicError(4, '请提供数据源地址！', req, res);
            return;
        }
        if (!req.port) {
            this.onLogicError(5, '请提供数据源端口！', req, res);
            return;
        }
        if (!req.database) {
            this.onLogicError(6, '请提供数据源的数据库名称！', req, res);
            return;
        }
        if (!req.user) {
            this.onLogicError(7, '请提供数据源用户名！', req, res);
            return;
        }
        if (!req.password) {
            this.onLogicError(8, '请提供数据源密码！', req, res);
            return;
        }
    }
    if (!server.config.DataSource) {
        this.onLogicError(9, '服务器未设置数据源！', req, res);
        return;
    }
    let ds;
    if (req.id == "default") {
        ds = server.config.Database;
    } else {
        if (!server.config.DataSource) {
            this.onLogicError(2, '服务器未设置数据源！', req, res);
            return;
        }
        for (var i = 0; i < server.config.DataSource.length; i++) {
            let dsTmp = server.config.DataSource[i];
            if (dsTmp.id == req.id) {
                ds = dsTmp;
                break;
            }
        }
        if (!ds) {
            this.onLogicError(2, '未找到ID为【' + req.id + '】的数据源！', req, res);
            return;
        }
    }
    if (req.type == "mssql") {
        ds.name = req.name;
        ds.server = req.host;
        ds.options.port = parseInt(req.port);
        ds.options.database = req.database;
        ds.authentication.options.userName = req.user;
        ds.authentication.options.password = req.password;
    } else {
        ds.name = req.name;
        ds.host = req.host;
        ds.port = parseInt(req.port);
        ds.database = req.database;
        ds.user = req.user;
        ds.password = req.password;
        if (req.schema) ds.schema = req.schema;
        //如果原来没设置schema，就需要将该参数设置为database一样的值
        //如果原来有值，就不需要再设置
        if (!ds.schema) ds.schema = req.database;
    }
    if (ds.type == "sqlite") {
        ds.filePath = req.filePath;
    }

    utils.saveJSONToFile(utils.getPath('/config/' + server.id + '.json'), server.config);

    this.end(res);
};
