var Service = require('Service');
var util = require('util');
var utils = require('utils');
var dsUtils = require('./dsUtils');

/**
 * 测试数据源信息
 */
var TestDataSource = function() { 
  Service.call(this);
  this.sqlInject = {check: false};
};

util.inherits(TestDataSource, Service);

module.exports = TestDataSource;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
TestDataSource.prototype.process =  function(req, res) { 
  if(!req.id) {
    this.onLogicError(1, '请提供数据源信息！', req, res);
    return;
  }
  if(req.name) {
    this.createDs(req, res);
    return;
  }
  if(!server.config.DataSource) {
    this.onLogicError(2, '服务器未设置数据源！', req, res);
    return;
  }
  let ds;
  for(var i=0;i<server.config.DataSource.length;i++) {
    let dsTmp = server.config.DataSource[i];
    if(dsTmp.id==req.id) {
      ds = dsTmp;
      break;
    }
  } 
  if(!ds) {
    this.onLogicError(3, '未找到数据源【'+req.id+'】！', req, res);
    return;
  }
  this.test(req, res, ds);  
};

TestDataSource.prototype.createDs =  function(req, res) { 
  if(!req.name) {
    this.onLogicError(2, '请提供数据源名称！', req, res);
    return;
  }
  if(!req.type) {
    this.onLogicError(3, '请提供数据源类型！', req, res);
    return;
  }
  if (req.type == 'sqlite') {
    if(!req.filePath) {
        this.onLogicError(4, '请提供文件路径！', req, res);
        return;
    }
  }
  else {
    if(!req.host) {
        this.onLogicError(4, '请提供数据源地址！', req, res);
        return;
    }
    if(!req.port) {
        this.onLogicError(5, '请提供数据源端口！', req, res);
        return;
    }
    if(!req.database) {
        this.onLogicError(6, '请提供数据源的数据库名称！', req, res);
        return;
    }
    if(!req.user) {
        this.onLogicError(7, '请提供数据源用户名！', req, res);
        return;
    }
    if(!req.password) {
        this.onLogicError(8, '请提供数据源密码！', req, res);
        return;
    }
  }

  let ds = dsUtils.createDsConfig(req);
  this.test(req, res, ds);
}

TestDataSource.prototype.test =  function(req, res, ds) { 
  let self = this;
  
  let Dao = require("Dao_"+ds.type);
  let dao = new Dao();
  dao.setConfig(ds);
  dao.bindService = false;
  dao.open(function(ret, err) {
    dao.close();
    if(err) {
      self.onLogicError(500, err.message, req, res);
      return;
    }
    self.end(res);
  });
};