var Service = require('Service');
var util = require('util');

/**
 * 获得数据源信息
 */
var GetDataSource = function() { 
  Service.call(this);
};

util.inherits(GetDataSource, Service);

module.exports = GetDataSource;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetDataSource.prototype.process =  function(req, res) { 
  res.data = [];
  if(req.getDefault) {
    let defaultDS = server.config.Database;
    res.data.push({
      id: "default",
      name: "默认数据库",
      type: defaultDS.type,
      host: defaultDS.host,
      port: defaultDS.port,
      database: defaultDS.database,
      user: defaultDS.user
    });
  }
  if(server.config.DataSource) {
    for(var i=0;i<server.config.DataSource.length;i++) {
      let ds = server.config.DataSource[i];
      let dsTmp = {
        id: ds.id,
        name: ds.name,
        type: ds.type
      };
      if(ds.type=="mssql") {
        dsTmp.host = ds.server;
        dsTmp.port = ds.options.port;
        dsTmp.database = ds.options.database;
        dsTmp.user = ds.authentication.options.userName;
      } else {
        dsTmp.host = ds.host;
        dsTmp.port = ds.port;
        dsTmp.database = ds.database;
        dsTmp.user = ds.user;
      }
      if(ds.type=="sqlite") {
        dsTmp.filePath = ds.filePath;
      }
      res.data.push(dsTmp);
    }
  }
  res.defaultDBType = server.config.Database.type;
  this.end(res);
};
