var Service = require('Service');
var util = require('util');

/**
 * 获得数据源信息
 */
var GetDataSource = function () {
    Service.call(this);
};

util.inherits(GetDataSource, Service);

module.exports = GetDataSource;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetDataSource.prototype.process = function (req, res) {
    if (!req.id) {
        this.onLogicError(1, '请提供数据源ID！', req, res);
        return;
    }
    let ds = null;
    if (req.id == "default") {
        ds = server.config.Database;
        res.ds = {
            id: "default",
            name: "任擎默认数据库",
            type: ds.type
        };
    } else {
        if (!server.config.DataSource) {
            this.onLogicError(2, '服务器未设置数据源！', req, res);
            return;
        }
        for (var i = 0; i < server.config.DataSource.length; i++) {
            let dsTmp = server.config.DataSource[i];
            if (dsTmp.id == req.id) {
                ds = dsTmp;
                break;
            }
        }
        if (!ds) {
            this.onLogicError(2, '未找到ID为【' + req.id + '】的数据源！', req, res);
            return;
        }
        res.ds = {
            id: ds.id,
            name: ds.name,
            type: ds.type
        };
    }
    if (ds.type == "mssql") {
        res.ds.host = ds.server;
        res.ds.port = ds.options.port;
        res.ds.database = ds.options.database;
        res.ds.user = ds.authentication.options.userName;
        res.ds.password = ds.authentication.options.password;
    } else {
        res.ds.host = ds.host;
        res.ds.port = ds.port;
        res.ds.database = ds.database;
        res.ds.user = ds.user;
        res.ds.password = ds.password;
    }
    if (ds.type == "sqlite") {
        res.ds.filePath = ds.filePath;
    }
    this.end(res);
};
