
var dsUtils = module.exports;

dsUtils.createDsConfig = function (req) {
	let ds;
  if(req.type=="mysql") {
    ds = {
      "id": req.id,
      "name": req.name,
      "type": "mysql",
      "host": req.host,
      "port": parseInt(req.port),
      "database": req.database,
      "user": req.user,
      "password": req.password,
      "charset": "UTF8MB4",
      "connectTimeout": 60000
    };
  } else if(req.type=="mssql") {
    ds = {
      "id": req.id,
      "name": req.name,
      "type": "mssql",
      "server": req.host,
      "authentication": {
        "type": "default",
        "options": {
          "userName": req.user,
          "password": req.password
        }
      },
      "options": {
        "trustServerCertificate": true,
        "cryptoCredentialsDetails": {
          "minVersion": "TLSv1"
        },
        "port": parseInt(req.port),
        "database": req.database
      }
    };
  } else if(req.type=="postgresql") {
    ds = {
      "id": req.id,
      "name": req.name,
      "type": "postgresql",
      "host": req.host,
      "port": parseInt(req.port),
      "database": req.database,
      "schema": "PUBLIC",
      "user": req.user,
      "password": req.password,
      "ssl": false
    };
  } else if(req.type=="kingbase") {
    ds = {
      "id": req.id,
      "name": req.name,
      "type": "kingbase",
      "version": "8.3",
      "host": req.host,
      "port": parseInt(req.port),
      "database": req.database,
      "schema": "PUBLIC",
      "user": req.user,
      "password": req.password,
      "ssl": false
    };
  } else if(req.type=="vastbase") {
    ds = {
      "id": req.id,
      "name": req.name,
      "type": "vastbase",
      "host": req.host,
      "port": parseInt(req.port),
      "database": req.database,
      "schema": "PUBLIC",
      "user": req.user,
      "password": req.password,
      "ssl": false
    };
  } else if(req.type=="sqlite") {
    ds = {
      "id": req.id,
      "name": req.name,
      "type": "sqlite",
      "filePath": req.filePath,
    };
  }
  return ds;
};