var Service = require('Service');
var util = require('util');
var utils = require('utils');

/**
 * 删除数据源信息
 */
var DeleteDataSource = function() { 
  Service.call(this);
};

util.inherits(DeleteDataSource, Service);

module.exports = DeleteDataSource;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
DeleteDataSource.prototype.process =  function(req, res) { 
  if(!req.id) {
    this.onLogicError(1, '请提供数据源ID！', req, res);
    return;
  }
  if(!server.config.DataSource) {
    this.onLogicError(9, '服务器未设置数据源！', req, res);
    return;
  }
  for(var i=0;i<server.config.DataSource.length;i++) {
    let dsTmp = server.config.DataSource[i];
    if(dsTmp.id==req.id) {
      server.config.DataSource.splice(i, 1);
      break;
    }
  }

  utils.saveJSONToFile(utils.getPath('/config/'+server.id+'.json'), server.config);
  
  this.end(res);
};
