var Service = require('Service');
var util = require('util');
var utils = require('utils');
var dsUtils = require('./dsUtils');

/**
 * 添加数据源信息
 */
var AddDataSource = function() { 
  Service.call(this);
  this.sqlInject = {check: false};
};

util.inherits(AddDataSource, Service);

module.exports = AddDataSource;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
AddDataSource.prototype.process =  function(req, res) { 
  if(!req.id) {
    this.onLogicError(1, '请提供数据源ID！', req, res);
    return;
  }
  req.id = req.id+'';
  if(req.id.match(/[^\w]/g)) {
    this.onLogicError(1, "数据源ID只能包含字母、数字或下划线！");
    return;
  }
  if(req.id=="default") {
    this.onLogicError(1, "数据源ID不能使用default！");
    return;
  }
  if(!req.name) {
    this.onLogicError(2, '请提供数据源名称！', req, res);
    return;
  }
  if(!req.type) {
    this.onLogicError(3, '请提供数据源类型！', req, res);
    return;
  }
  if (req.type == 'sqlite') {
    if(!req.filePath) {
        this.onLogicError(4, '请提供文件路径！', req, res);
        return;
    }
  }
  else {
    if(!req.host) {
        this.onLogicError(4, '请提供数据源地址！', req, res);
        return;
    }
    if(!req.port) {
        this.onLogicError(5, '请提供数据源端口！', req, res);
        return;
    }
    if(!req.database) {
        this.onLogicError(6, '请提供数据源的数据库名称！', req, res);
        return;
    }
    if(!req.user) {
        this.onLogicError(7, '请提供数据源用户名！', req, res);
        return;
    }
    if(!req.password) {
        this.onLogicError(8, '请提供数据源密码！', req, res);
        return;
    }
  }
  if(server.config.DataSource) {
    for(var i=0;i<server.config.DataSource.length;i++) {
      let ds = server.config.DataSource[i];
      if(ds.id==req.id) {
        this.onLogicError(9, '数据源【'+req.id+'】已存在！', req, res);
        return;
      }
    }
  } else {
    server.config.DataSource = [];
  }
  
  let ds = dsUtils.createDsConfig(req);

  server.config.DataSource.push(ds);

  utils.saveJSONToFile(utils.getPath('/config/'+server.id+'.json'), server.config);
  
  this.end(res);
};
