var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * 批量修改数据
 */
var BatchUpdateData = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(BatchUpdateData, Service);

module.exports = BatchUpdateData;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
BatchUpdateData.prototype.process =  function(dao, where, keys, dataList, cb) {
  let keyFieldNames = "";
  let keyWhere = "";
  let updateWhere = where;
  for(let i=0;i<keys.length;i++) {
    if(i>0) {
        keyFieldNames += ",";
        keyWhere += " and ";
    }
    let keyName = keys[i];
    keyFieldNames += keyName;
    keyWhere += " "+keyName+" in (";
    let haveAddKeyVal = false;
    for(let j=0;j<dataList.length;j++) {
        let data = dataList[j];
        let keyVal = data[keyName];
        if(!keyVal && keyVal!=0) continue;
        if(haveAddKeyVal) keyWhere += ",";
        if(!isNaN(keyVal)) {
            keyWhere += keyVal;
        } else {
            keyWhere += "'"+keyVal+"'";
        }
        haveAddKeyVal = true;
    }
    keyWhere += ") ";
    if(updateWhere.indexOf("#{"+keyName+"}")<0) {
        if(updateWhere!="") updateWhere += " and ";
        updateWhere += " "+keyName+"={"+keyName+"}";
    }
  }
  var self = this;
  //先查现有数据记录
  dao.execute("select "+keyFieldNames+" from "+dao.model.table+" where "+where, null, function(rows){
    let dataListU = [];  //需要修改的记录
    let dataListI = [];  //需要添加的记录
    let dataListD = [];  //需要删除的记录
    //先查找需要删除的记录
    for(let i=0;i<rows.length;i++) {
        let row = rows[i];
        let oldExists = false;
        for(let j=0;j<dataList.length;j++) {
            let data = dataList[j];
            let exists = true;
            for(let k=0;k<keys.length;k++) {
                let keyName = keys[k];
                if (row[keyName.toLowerCase()]+''!=data[keyName]+'') {
                    exists = false;
                    break;
                }
            }
            if(exists) {
                oldExists = true;
                break;
            }
        }
        if(!oldExists) dataListD.push(row);
    }
    //再查找需要修改或添加的数据
    for(let i=0;i<dataList.length;i++) {
        let data = dataList[i];
        let newExists = false;
        for(let j=0;j<rows.length;j++) {
            let row = rows[j];
            let exists = true;
            for(let k=0;k<keys.length;k++) {
                let keyName = keys[k];
                if (row[keyName.toLowerCase()]+''!=data[keyName]+'') {
                    exists = false;
                    break;
                }
            }
            if(exists) {
                newExists = true;
                break;
            }
        }
        if(newExists) {
            dataListU.push(data);
        } else {
            dataListI.push(data);
        }
    }
    if(dataListD.length==0) {
        cb(dataListU, dataListI, updateWhere);
        return;
    }
    //生成删除数据的查询条件
    let delWhere = "";
    for(let i=0;i<keys.length;i++) {
      if(i>0) {
          delWhere += " and ";
      }
      let keyName = keys[i].toLowerCase();
      delWhere += " "+keyName+" in (";
      let haveAddKeyVal = false;
      for(let j=0;j<dataListD.length;j++) {
          let data = dataListD[j];
          let keyVal = data[keyName];
          if(!keyVal && keyVal!=0) continue;
          if(haveAddKeyVal) delWhere += ",";
          if(isNaN(keyVal)) {
            delWhere += keyVal;
          } else {
            delWhere += "'"+keyVal+"'";
          }
          haveAddKeyVal = true;
      }
      delWhere += ") ";
    }
    //删除数据
    dao.execute("delete from "+dao.model.table+" where "+delWhere, null, function(){
        cb(dataListU, dataListI, updateWhere);
    });
  });
};
