//var fs = require('fs');

var DataProcessUtils = module.exports;

/**
 * 日期加减
 * @param {*} d 日期
 * @param {*} t 类型
 * @param {*} n 数量
 */
DataProcessUtils.addDate = function (d, t, n) {
    var d2 = new Date(d);
    if (t == "year") {
      d2.setFullYear(d2.getFullYear() + n);
    } else if (t == "month") {
      d2.setMonth(d2.getMonth() + n);
    } else if (t == "date") {
      d2.setDate(d2.getDate() + n);
    } else if (t == "week") {
      d2.setDate(d2.getDate() + n * 7);
    } else if (t == "hour") {
      d2.setHours(d2.getHours() + n);
    } else if (t == "minute") {
      d2.setMinutes(d2.getMinutes() + n);
    } else if (t == "second") {
      d2.setSeconds(d2.getSeconds() + n);
    }
    return d2;
}

/**
 * 补齐日期
 * @param {*} rows 
 * @param {*} dateField 
 * @param {*} dataFields 
 * @param {*} endDate 
 * @param {*} days 
 * @returns 
 */
DataProcessUtils.fillDate = function (rows, dateField, dataFields, endDate, days) {
    if(!rows || !dateField || !dataFields || !days) return [];
    let rowsRet = [];
    let rowIndexs = {};
    let _endDate = new Date();
    if(endDate) _endDate = typeof(endDate)=="string" ? new Date(endDate) : endDate;
    let arrDataFields = dataFields.split(",");
    for (let i = days-1; i >= 0; i--) {
        let row = {};
        let dateTmp = DataProcessUtils.addDate(_endDate, 'date', -i);
        row[dateField] = dateTmp.format('yyyy-MM-dd');
        for(let j=0;j<arrDataFields.length;j++) {
            row[arrDataFields[j]] = 0;
        }
        rowsRet.push(row);
        rowIndexs[row[dateField]] = days - 1 - i;
    }
    for(let i=0;i<rows.length;i++) {
        let rowTmp = rows[i];
        let index = rowIndexs[rowTmp[dateField]];
        if(!index) continue;
        let row = rowsRet[index];
        for(let j=0;j<arrDataFields.length;j++) {
            let dataField = arrDataFields[j];
            row[dataField] = rowTmp[dataField];
        }
    }
    return rowsRet;
}

/**
 * 补全月份数据
 * @param {*} rows 
 * @param {*} monthField 
 * @param {*} dataFields 
 * @returns 
 */
DataProcessUtils.fillMonth = function (rows, monthField, dataFields) {
    if(!rows || !monthField || !dataFields) return [];
    let rowsRet = [];
    let rowIndexs = {};
    let arrDataFields = dataFields.split(",");
    for (let i = 1; i <= 12; i++) {
        let row = {};
        let month = i<10 ? "0"+i : i+"";
        row[monthField] = month;
        for(let j=0;j<arrDataFields.length;j++) {
            row[arrDataFields[j]] = 0;
        }
        rowsRet.push(row);
        rowIndexs[row[monthField]] = i-1;
    }
    for(let i=0;i<rows.length;i++) {
        let rowTmp = rows[i];
        let index = rowIndexs[rowTmp[monthField]];
        if(!index) continue;
        let row = rowsRet[index];
        for(let j=0;j<arrDataFields.length;j++) {
            let dataField = arrDataFields[j];
            row[dataField] = rowTmp[dataField];
        }
    }
    return rowsRet;
}

/**
 * 补全周数据
 * @param {*} rows 
 * @param {*} weekField 
 * @param {*} dataFields 
 * @returns 
 */
DataProcessUtils.fillWeek = function (rows, weekField, dataFields) {
    if(!rows || !weekField || !dataFields) return [];
    let rowsRet = [];
    let rowIndexs = {};
    let arrDataFields = dataFields.split(",");
    for (let i = 0; i <= 6; i++) {
        let row = {};
        let week = i;
        row[weekField] = week;
        for(let j=0;j<arrDataFields.length;j++) {
            row[arrDataFields[j]] = 0;
        }
        rowsRet.push(row);
        rowIndexs[row[weekField]] = i;
    }
    for(let i=0;i<rows.length;i++) {
        let rowTmp = rows[i];
        let index = rowIndexs[rowTmp[weekField]];
        if(!index) continue;
        let row = rowsRet[index];
        for(let j=0;j<arrDataFields.length;j++) {
            let dataField = arrDataFields[j];
            row[dataField] = rowTmp[dataField];
        }
    }
    return rowsRet;
}

/**
 * 补全当月1号到现在数据
 * @param {*} rows 
 * @param {*} dateField 
 * @param {*} dataFields 
 */
DataProcessUtils.fillCurMonthToNow = function (rows, dateField, dataFields) {
    let endDate = new Date();
    return DataProcessUtils.fillDate(rows, dateField, dataFields, endDate, endDate.getDate());
}

/**
 * 补全当月全月数据
 * @param {*} rows 
 * @param {*} dateField 
 * @param {*} dataFields 
 */
DataProcessUtils.fillCurMonthAllDate = function (rows, dateField, dataFields) {
    let now = DataProcessUtils.addDate(new Date(), "month", 1);
    let endDate = new Date(now.getFullYear(), now.getMonth(), 0);
    return DataProcessUtils.fillDate(rows, dateField, dataFields, endDate, endDate.getDate());
}

/**
 * 补全指定月份全月数据
 * @param {*} rows 
 * @param {*} dateField 
 * @param {*} dataFields 
 */
DataProcessUtils.fillMonthAllDate = function (rows, dateField, dataFields, year, month) {
    let endDate = new Date(year, month, 0);
    return DataProcessUtils.fillDate(rows, dateField, dataFields, endDate, endDate.getDate());
}