var crypto = require('crypto');
var http = require('http');
var https = require('https');
var net = require('net');
var url = require('url');
var BufferHelper = require('BufferHelper');

var tbsClient = module.exports;

/**
 * AES加密
 * @param {*} dataStr 
 * @param {*} key 
 * @param {*} iv 
 * @returns 
 */
tbsClient.encryptAES = function (dataStr, key, iv) {
    let cipherChunks = [];
    let cipher = crypto.createCipheriv('aes-256-cbc', key, iv);
    cipher.setAutoPadding(true);
    cipherChunks.push(cipher.update(dataStr, 'utf8', 'base64'));
    cipherChunks.push(cipher.final('base64'));
    return cipherChunks.join('');
};

/**
 * AES解密
 * @param {*} dataStr 
 * @param {*} key 
 * @param {*} iv 
 * @returns 
 */
tbsClient.decryptAES = function (dataStr, key, iv) {
  let cipherChunks = [];
  let decipher = crypto.createDecipheriv('aes-256-cbc', key, iv);
  decipher.setAutoPadding(true);
  cipherChunks.push(decipher.update(dataStr, 'base64', 'utf8'));
  cipherChunks.push(decipher.final('utf8'));
  return cipherChunks.join('');
};

  /**
 * MD5加密
 * @param {*} str 
 * @returns 
 */
tbsClient.md5 = function (str) {
    var md5 = crypto.createHash('md5');
    md5.update(str, 'utf8');
    return md5.digest('hex');
};

/**
 * 获得身份验证数据
 * @param {*} orgCode 
 * @param {*} orgKey 
 * @param {*} loginname 
 * @param {*} password 
 * @returns 
 */
tbsClient.getAuthData = function(orgCode, orgKey, loginname, password) {
    let ret = {};
    ret._auth_ts = (new Date()).getTime();
    ret._auth_org = orgCode;
    var signData = [orgCode, orgKey, ret._auth_ts];
    var iv = tbsClient.md5(JSON.stringify(signData)).substr(0, 16);
    signData.push(iv);
    var key = tbsClient.md5(JSON.stringify(signData));
    var loginData = ['loginname', loginname, 'web'];
    signData.push(tbsClient.md5(password));
    loginData.push(tbsClient.md5(JSON.stringify(signData)));
    signData = null;
    ret._auth_data = tbsClient.encryptAES(JSON.stringify(loginData), key, iv);
    return ret;
};

/**
 * 发送HTTP请求
 * @param  {[type]}   options        [请求选项]
 * @param  {[type]}   servicePath    [服务地址]
 * @param  {[type]}   args           [请求参数]
 * @param  {Function} cb             [回调函数]
 * @return {[type]}                  [description]
 */
tbsClient.request = function (options, servicePath, args, cb) {
    if(!options) {
      if(cb) cb("请提供选项对象！");
      return;
    }
    if(!options.serverAddress) {
      if(cb) cb("请提供服务器地址！");
      return;
    }
    if(!servicePath) {
      if(cb) cb("请提供服务路径！");
      return;
    }

    var httpClient = http;
    var optionsReq = {
      method: "post",
      hostname: options.serverAddress,
      port: 80
    };
    if(options.useHttps) {
      optionsReq.port = 443;
      optionsReq.json = true;
      optionsReq.rejectUnauthorized = true;
      httpClient = https;
    }
    if(options.serverPort) optionsReq.port = options.serverPort;
    optionsReq.path = "/Service?service="+servicePath;
  
    var reqHttp = httpClient.request(optionsReq, function(resHttp) {
      resHttp.setEncoding('utf8');
      var bufferHelper = new BufferHelper();
      resHttp.on('data', function (chunk) {
        bufferHelper.concat(new Buffer(chunk));
      });
      resHttp.on('end', function() {
        var postData = bufferHelper.toBuffer().toString();
        bufferHelper = null;
        console.log('收到HTTP响应数据：'+postData);
        try {
          postData = JSON.parse(postData);
        } catch(err) {
          console.log(err);
          if(cb) cb(err.message);
          return;
        }
        if(cb) cb(null, postData);
      });
    });
  
    reqHttp.on('error', function(err) {
      console.log('发送HTTP请求时发生意外错误：' + err.message);
      if(cb) cb(err.message);
    });

    reqHttp.setHeader("Content-Type", "application/x-www-form-urlencoded");

    let _args = args;
    if(options.orgCode && options.orgKey && options.loginname && options.password) {
      let ret = tbsClient.getAuthData(options.orgCode, options.orgKey, options.loginname, options.password);
      if(!_args) _args = {};
      _args._auth_org = options.orgCode;
      _args._auth_data = ret._auth_data;
      _args._auth_ts = ret._auth_ts;
    }
  
    if(_args) {
      var str = JSON.stringify(_args);
      console.log('发送HTTP请求数据：'+str);
      reqHttp.setHeader("Content-Length", Buffer.byteLength(str, 'utf8'));
      reqHttp.write(str);
    }
  
    reqHttp.end();
  };

  //登录
  tbsClient.login = function(options, cb) {
    if(!options) {
      if(cb) cb('请提供登录选项！');
      return;
    }
    if(!options.serverAddress) {
      if(cb) cb('请提供服务器地址！');
      return;
    }
    if(!options.loginname) {
      if(cb) cb('请提供用户名！');
      return;
    }
    if(!options.password) {
      if(cb) cb('请提供登录密码！');
      return;
    }

    var args = {};
    args.loginname = options.loginname;
    args.clientType = 'web';
    args.ts = new Date().getTime();
    let pwd = tbsClient.md5(options.password);
    var ivData = [args.loginname, pwd, args.clientType, args.ts];
    var iv = tbsClient.md5(JSON.stringify(ivData)).substr(0, 16);
    ivData.push(iv);
    var key = tbsClient.md5(JSON.stringify(ivData));
    args.data = tbsClient.encryptAES(JSON.stringify(ivData), key, iv);
    ivData = null;

    tbsClient.request(options, "sys/service/login", args, function(err, res) {
      if(err) {
        if(cb) cb(err);
        return;
      }
      
      let authData = res.data;
      let authTs = res.ts;
      let ivData = [args.loginname, pwd, 'web', parseInt(authTs)];
      let iv = tbsClient.md5(JSON.stringify(ivData)).substr(0, 16);
      ivData.push(iv);
      let key = tbsClient.md5(JSON.stringify(ivData));
      let data = tbsClient.decryptAES(authData, key, iv);
      let arr = JSON.parse(data);
      var ret = {
        orgCode: arr[0],
        orgKey: arr[2],
        userId: arr[1]
      };
      arr = null;
      data = null;
      ivData = null;
      if(cb) cb(null, ret);
    });
  }
