const Service = require('Service');
const utils = require('utils');
const util = require('util');
const Dao = require('Dao');
const nodemailer = require("nodemailer");

/**
 * 发送电子邮件
 */
const SendMail = function () {
    Service.call(this);
};

util.inherits(SendMail, Service);

module.exports = SendMail;

/**
 * @param  {Object} req                 服务请求对象
 * @param  {Object} res                 服务响应对象
 */
SendMail.prototype.process = async function (req, res) {
  let self = this;

  if(!server.config.SendMail) {
    this.onLogicError(1, "请在服务器配置文件中配置发送邮件的相关参数！", req, res);
    return;
  }

  if(!server.config.SendMail.host) {
    this.onLogicError(2, "请在服务器配置文件中配置发送邮件的SMTP服务器地址！");
    return;
  }

  if(!server.config.SendMail.user) {
    this.onLogicError(3, "请在服务器配置文件中配置登录SMTP服务器的账号！");
    return;
  }

  if(!server.config.SendMail.pass) {
    this.onLogicError(4, "请在服务器配置文件中配置登录SMTP服务器的授权码！");
    return;
  }

  if(!server.config.SendMail.from) {
    this.onLogicError(5, "请在服务器配置文件中配置发送邮件的邮箱地址！");
    return;
  }

  if(!req.subject) {
    this.onLogicError(6, "请提供邮件主题！");
    return;
  }

  if(!req.to) {
    this.onLogicError(7, "请提供收件人信息！");
    return;
  }

  if(!req.html) {
    this.onLogicError(8, "请提供邮件正文！");
    return;
  }

  // 创建一个smtp客户端配置
  let config = {
    host: server.config.SendMail.host,
    secure: true,
    auth: {
      // 发件人邮箱账号
      user: server.config.SendMail.user,
      pass: server.config.SendMail.pass //授权码生成之后，要等一会才能使用，否则验证的时候会报错
    }
  }
  if(server.config.SendMail.port) config.port = server.config.SendMail.port;
  if(server.config.SendMail.secure==false) config.secure = false;

  const transporter = nodemailer.createTransport(config)
  
  //创建一个收件人对象
  let mail = {
    // 发件人 邮箱 '昵称<发件人邮箱>'
    from: server.config.SendMail.from,
    // 主题
    subject: req.subject,
    // 收件人 的邮箱
    to: req.to,
    //这里可以添加html标签
    html: req.html
  }

  transporter.sendMail(mail, function(error, info) {
    transporter.close()
    if (error) {
      self.onError(error);
      return;
    }

    logger.log('邮件已发送：'+info.response)
    self.end(res);
  });
}