const Service = require('Service');
const utils = require('utils');
const util = require('util');
const Dao = require('Dao');

/**
 * 发送短信
 */
const SendSMS = function () {
    Service.call(this);
};

util.inherits(SendSMS, Service);

module.exports = SendSMS;

/**
 * @param  {Object} req                 服务请求对象
 * @param  {Object} res                 服务响应对象
 */
SendSMS.prototype.process = async function (req, res) {

    if (!server.config.SendSMS) {
        this.onLogicError(1, "请在服务器配置文件中配置发送短信的相关参数！", req, res);
        return;
    }

    if (!server.config.SendSMS.accessKeyId) {
        this.onLogicError(2, "请在服务器配置文件中配置发送短信的授权ID！");
        return;
    }

    if (!server.config.SendSMS.accessKeySecret) {
        this.onLogicError(3, "请在服务器配置文件中配置发送短信的密钥！");
        return;
    }

    if (!req.phoneNumbers) {
        this.onLogicError(4, "请提供接收人手机号！");
        return;
    }

    if (!req.signName) {
        this.onLogicError(5, "请提供短信签名！");
        return;
    }

    if (!req.templateCode) {
        this.onLogicError(6, "请提供模版代码！");
        return;
    }

    if (!req.templateParam) {
        this.onLogicError(7, "请提供短信模版！");
        return;
    }

    var self = this;
    const Core = require('@alicloud/pop-core');
    var client = new Core({
        accessKeyId: server.config.SendSMS.accessKeyId,
        accessKeySecret: server.config.SendSMS.accessKeySecret,
        endpoint: 'https://dysmsapi.aliyuncs.com',
        apiVersion: '2017-05-25'
    });
    var params = {
        "PhoneNumbers": req.phoneNumbers, //接收短信的手机号码
        "SignName": req.signName, //短信签名名称
        "TemplateCode": req.templateCode, //短信模板CODE
        "TemplateParam": req.templateParam
    }
    var requestOption = {
        method: 'POST'
    };
    client.request('SendSms', params, requestOption).then((result) => {
        if (result && result.Code == "OK") {
            res.send_status = 0;
        } else {
            res.send_status = 1;
        }
        self.end(res);
    }, (ex) => {
        console.log(ex);
        res.send_status = 1;
        self.end(res);
    });
}