const Service = require('Service');
const utils = require('utils');
const util = require('util');
const Dao = require('Dao');

const UniqueVerify = function () {
    Service.call(this);
};

util.inherits(UniqueVerify, Service);

module.exports = UniqueVerify;

/**
 * 唯一校验
 * @param  {Object} req                 服务请求对象
 * @param  {Object} req.model           模型对象
 * @param  {String} req.tableName       模型名称
 * @param  {String} req.field           校验字段
 * @param  {String} req.value           校验内容
 * @param  {String} [req.excludeField]  排除字段
 * @param  {Any}    [req.excludeValue]  排除内容
 * @param  {String} [req.where]         默认条件
 * @param  {Object} res                 服务响应对象
 */
UniqueVerify.prototype.process = async function (req, res) {
    const { tableName, field, value, excludeField, excludeValue, where } = req;
    if (!tableName) return this.onLogicError(1, '请提供表名！');
    if (!field) return this.onLogicError(4, '请提供校验字段！');
    if (!value) return this.onLogicError(5, '请提供校验内容！');

    const dao = new Dao(this);
    let sql = `select ${field} from ${tableName} where ${field}=?`;
    let param = [value];
    if (excludeField && excludeValue) {
        sql += ` and ${excludeField}<>?`;
        param.push(excludeValue);
    }
    if (where) {
        sql += ` and ${where}`;
    }
    const rows = await dao.executeSync(sql, param);
    if (rows.length > 0) return this.onLogicError(6, '当前内容已存在！');
    this.end(res);
}