var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 获得角色用户列表
 */
var GetRoleUsers = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetRoleUsers, Service);

module.exports = GetRoleUsers;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetRoleUsers.prototype.process =  function(req, res) {
  if(!req.roleId) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  var self = this;
  req.session.cache.getList("mownrole", "#{role_id}==" + req.roleId, function(err, roleUser) {
    if (err) {
      self.onLogicError(2, '请提供正确的角色编号！');
      return;
    }
    res.users = [];
    if (roleUser.length == 0) {
      self.end(res);
      return;
    }
    var userId = [];
    for (var i = 0; i < roleUser.length; i++) {
      userId.push(roleUser[i].user_id);
    }
    req.session.cache.getList("user", "[" + userId.join() + "].contains(#{id})", function(err, users) {
      if (err) {
        self.onLogicError(2, '请提供正确的角色编号！');
        return;
      }
      for (var i = 0 ; i < users.length; i++) {
        var user = users[i];
        var userInfo = [user.id,user.code,user.name,user.head_id,user.sex,'',''];
        res.users.push(userInfo);
      }
      self.end(res);
    });
  });

  // var role = req.session.org.roles[req.roleId];
  // if(!req.roleId) {
  //   this.onLogicError(2, '请提供正确的角色编号！');
  //   return;
  // }
  
  // res.role = {id:role.id,code:role.code,name:role.name};
  // res.users = [];
  // for(var i=0;i<role.users.length;i++) {
  // 	var user = req.session.org.users[parseInt(role.users[i])];
  // 	if(!user) continue;
  //   var userInfo = [user.id,user.code,user.name,user.head_id,user.sex];
  //   if(user.deps && user.deps.length>0) {
  //     var dep = req.session.org.deps[user.deps[0]];
  //     if(dep) {
  //       userInfo.push(dep.code);
  //       userInfo.push(dep.name);
  //     } else {
  //       userInfo.push('');
  //       userInfo.push('');
  //     }
  //   } else {
  //     userInfo.push('');
  //     userInfo.push('');
  //   }
  //   res.users.push(userInfo);
  //   if(res.users.length>=100) break;
  // }
  // res.userCount = role.users.length;
  // this.end(res);
};