var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 获得部门用户列表
 */
var GetDepUsers = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetDepUsers, Service);

module.exports = GetDepUsers;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetDepUsers.prototype.process =  function(req, res) {
  if(!req.depId) {
    this.onLogicError(1, '请提供部门编号！');
    return;
  }
  
  var self = this;
  req.session.cache.getList("mdeppost", "#{dep_id}==" + req.depId + " && #{order_number}==1", function(err, depUser) {
    if (err) {
      self.onLogicError(2, '请提供正确的部门编号！');
      return;
    }
    res.users = [];
    if (depUser.length == 0) {
      self.end(res);
      return;
    }
    var userId = [];
    for (var i = 0; i < depUser.length; i++) {
      userId.push(depUser[i].user_id);
    }
    req.session.cache.getList("user", "[" + userId.join() + "].contains(#{id})", function(err, users) {
      if (err) {
        self.onLogicError(2, '请提供正确的部门编号！');
        return;
      }
      for (var i = 0 ; i < users.length; i++) {
        var user = users[i];
        var userInfo = [user.id,user.code,user.name,user.head_id,user.sex,'',''];
        res.users.push(userInfo);
      }
      self.end(res);
    });
  });

  // var dep = req.session.org.deps[req.depId];
  // if(!req.depId) {
  //   this.onLogicError(2, '请提供正确的部门编号！');
  //   return;
  // }
  
  // res.dep = {id:dep.id,code:dep.code,name:dep.name};
  // res.users = [];
  // for(var i=0;i<dep.users.length;i++) {
  // 	var user = req.session.org.users[parseInt(dep.users[i])];
  // 	if(!user) continue;
  // 	res.users.push([user.id,user.code,user.name,user.head_id,user.sex]);
  //   if(res.users.length>=100) break;
  // }
  // res.userCount = dep.users.length;
  // this.end(res);
};