var Service = require('Service');
var util = require('util');
var Dao = require('Dao');

/**
 * 获得缓存数据
 */
var GetCache = function () {
    Service.call(this);
};

util.inherits(GetCache, Service);

module.exports = GetCache;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetCache.prototype.process = function (req, res) {
    var self = this;
    if (!req.modelName) {
      this.onLogicError(1, '请提供要查询的模型名称！', req);
      return;
    }
    if (!req.operate) {
      this.onLogicError(2, '请提供操作类型！', req);
      return;
    }
    req.session.cache.exec({
        modelName: req.modelName,
        operate: req.operate,
        arg: req.arg
    }, function (cacheData, args) {
        var ret = null;
        if(args.operate=="get") {
            ret = cacheData[args.modelName].values[args.arg];
        } else if(args.operate=="getList") {
            ret = cacheData[args.modelName].values;
        } else if(args.operate=="getKeys") {
            ret = cacheData[args.modelName].keys;
        } else if(args.operate=="getModel") {
            ret = cacheData[args.modelName].modeInfo;
        } else if(args.operate=="getMetaData") {
            ret = cacheData[args.modelName].metadata;
        }
        return ret;
    }, function (err, ret) {
        if (err) {
            console.log(err);
            return;
        }
        res.data = ret;
        self.end(res);
    });
};