var Service = require('Service');
var utils = require('utils');
var util = require('util');
var fs = require('fs');

/**
 * 修改
 */
var Update = function() { 
  Service.call(this);
};

util.inherits(Update, Service);

module.exports = Update;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Update.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供服务ID！');
    return;
  }
  var bgService = server.bgServices[req.id];
  if(!bgService) {
    this.onLogicError(5, '请提供正确的服务ID！');
    return;
  }
  if(!req.name) {
    this.onLogicError(2, '请提供服务名称！');
    return;
  }
  if(!req.path) {
    this.onLogicError(3, '请提供服务路径！');
    return;
  }
  var servicePath = utils.getPath(utils.appendPath('/app', req.path));
  if(!fs.existsSync(servicePath)) {
    this.onLogicError(4, '请提供正确的服务路径！');
    return;
  }
  for(sid in server.bgServices) {
    var service = server.bgServices[sid];
    if((service.name==req.name || service.path==req.path) && service.id != req.id) {
      this.onLogicError(5, '名称或路径已经存在！');
      return;
    }
  }
  bgService.name = req.name;
  bgService.path = req.path;

  for(let i=0;i<server.config.BackgroundServices.length;i++) {
    let bsConfig = server.config.BackgroundServices[i];
    if(bsConfig.id==bgService.id) {
      bsConfig.name = req.name;
      bsConfig.path = req.path;
      break;
    }
  }

  utils.saveJSONToFile(utils.getPath('/config/'+server.id+'.json'), server.config);

  this.end(res);
};