var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 停止
 */
var Stop = function () {
  Service.call(this);
};

util.inherits(Stop, Service);

module.exports = Stop;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Stop.prototype.process = function (req, res) {
  if (!req.id) {
    this.onLogicError(1, '请提供服务ID！');
    return;
  }
  var bgService = server.bgServices[req.id];
  if (!bgService) {
    this.onLogicError(5, '请提供正确的服务ID！');
    return;
  }
  if (!bgService.isRunning) {
    this.onLogicError(5, '服务已停止！');
    return;
  }
  try {
    bgService.isRunning = false;
    bgService.isRunInBackground = false;
    bgService.stop();
  } catch (err) {
    this.onError(err);
    return;
  }

  if (!server.config.BackgroundServices || server.config.BackgroundServices.length == 0) {
    this.end(res);
    return;
  }

  for (var i = 0; i < server.config.BackgroundServices.length; i++) {
    var serviceInfo = server.config.BackgroundServices[i];
    if(serviceInfo.id==req.id) {
      serviceInfo.disable = true;
      utils.saveJSONToFile(utils.getPath('/config/' + server.id + '.json'), server.config);
      break;
    }
  }

  this.end(res);
};