var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 获得临时性后台服务状态
 */
var GetTmpBGServiceStatus = function () {
    Service.call(this);
    this.checkLogin = false;
    this.checkAuthority = false;
};

util.inherits(GetTmpBGServiceStatus, Service);

module.exports = GetTmpBGServiceStatus;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetTmpBGServiceStatus.prototype.process = function (req, res) {
    if (!req.serviceId) {
        this.onLogicError(1, '请提供服务ID！');
        return;
    }
    res.serviceInfo = server.tmpBGServices[req.serviceId];
    if (!res.serviceInfo) {
        this.onLogicError(5, '请提供正确的服务ID！');
        return;
    }
    this.end(res);
};