var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 删除
 */
var Delete = function () {
  Service.call(this);
};

util.inherits(Delete, Service);

module.exports = Delete;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Delete.prototype.process = function (req, res) {
  if (!req.id) {
    this.onLogicError(1, '请提供服务ID！');
    return;
  }
  var bgService = server.bgServices[req.id];
  if (!bgService) {
    this.onLogicError(5, '请提供正确的服务ID！');
    return;
  }
  if (bgService.isRunning) {
    this.onLogicError(5, '服务正在运行，不能删除！');
    return;
  }
  try {
    bgService.isRunning = false;
    bgService.isRunInBackground = false;
    // bgService.stop();
  } catch (err) {
    this.onError(err);
    return;
  }

  delete server.bgServices[req.id];

  for (var i = 0; i < server.config.BackgroundServices.length; i++) {
    if (server.config.BackgroundServices[i].id == req.id) {
      server.config.BackgroundServices.splice(i, 1);
      break;
    }
  }

  utils.saveJSONToFile(utils.getPath('/config/' + server.id + '.json'), server.config);

  this.end(res);
};