var Service = require('Service');
var utils = require('utils');
var util = require('util');

/**
 * 后台驻留服务示例
 */
var BGServiceDemo = function() { 
  // this.status = 0;
  this.isRunning = true;
};

util.inherits(BGServiceDemo, Service);

module.exports = BGServiceDemo;

/**
 * 启动服务
 */
BGServiceDemo.prototype.start =  function() {
  console.log("正在启动服务....");
  this.isRunning = true;
  this.poll();
};

/**
 * 演示代码：每隔3秒控制台输出一下时间
 * @return {[type]} [description]
 */
BGServiceDemo.prototype.poll =  function() {
  if(!this.isRunning) {
    console.log("服务已停止。");
    return;
  }
  var self = this;
  setTimeout(function() {
    console.log((new Date()).format("hh:mm:ss"));
    self.poll();
  }, 1000);
};

/**
 * 停止服务
 * @return {[type]} [description]
 */
BGServiceDemo.prototype.stop =  function() {
  console.log("正在停止服务....");
  this.isRunning = false;
};