var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('Dao');

/**
 * Getlist
 * 查询sys_app_attach_type
 */
var Getlist = function() { 
  Service.call(this);
  this._dao = new Dao(this);
};

util.inherits(Getlist, Service);

module.exports = Getlist;

/**
 * 处理服务请求
 * @param  {object} req 服务请求对象
 * @param  {object} res 服务响应对象
 */
Getlist.prototype.process =  function(req , res) {
  var self = this;
  let params = [];
  let where = "";
  if(!utils.isNull(req.name)) {
    where += "name like ?";
    params.push("%"+req.name+"%");
  }
  if(!utils.isNull(req.type)) {
    if(where!="") where += " and ";
    where += "type=?";
    params.push(req.type);
  }
  if(!utils.isNull(req.app_data_id)) {
    if(where!="") where += " and ";
    where += "app_data_id=?";
    params.push(req.app_data_id);
  }
  if(!utils.isNull(req.time1)){
    if(where!="") where += " and ";
    where += "upload_time >=?";
    params.push(req.time1);
  }  
  if(!utils.isNull(req.time2)){
    if(where!="") where += " and ";
    where += "upload_time <=?";
    params.push(req.time2);
  }   
  if(!utils.isNull(req.id)) {
     if(where!="") where += " and ";
    where += "app_code=(SELECT app_code FROM sys_app_attach_type WHERE id = ?)";
    params.push(req.id);
  }
  if(where=="") where = " 1=1 ";
  options = {
    sql: "select id,code,name,size,type,app_code,app_data_id,uploader_id,upload_time,save_path,org_id,uploader_name from sys_app_attach where "+where+"",
    params: params,
    count_sql: "select count(*) as count_ from (select id,code,name,size,type,app_code,app_data_id,uploader_id,upload_time,save_path,org_id,uploader_name from sys_app_attach where "+where+") count_rows ",
    count_params: params,
    order: "upload_time desc"
  };
  if(!req.pageSize) req.pageSize = 20;
  self._dao.queryDataPage(
    req, options,
    function(rows) {
    res.data = rows;
    self.end(res);
  });
};
