var util = require('util');
var path = require('path');
var Service = require('Service');
var utils = require('utils');
var request = require('request');

/**
 * 上传附件
 */
var UploadAttachByWPS = function () {
    Service.call(this);
    this.checkAuthority = false;
    this.checkLogin = false;
    var host = "http://127.0.0.1:" + server.config.Port;
    this.options = {
        'method': 'POST',
        'url': host + "/TaskMsgService",
        'headers': {
            'Content-Type': 'application/json'
        }
    };
};

util.inherits(UploadAttachByWPS, Service);

module.exports = UploadAttachByWPS;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UploadAttachByWPS.prototype.process = function (req, res) {

    if (!req.oriCode) {
        this.onLogicError(1, '请提供原始文件编码！', req);
        return;
    }
    if (!req.fileCode) {
        this.onLogicError(2, '请提供文件编码！', req);
        return;
    }
    if (!req.fileSize) {
        this.onLogicError(3, '请提供文件大小！', req);
        return;
    }
    if (!req.user_id) {
        this.onLogicError(3, '请提供用户编号！', req);
        return;
    }

    var self = this;

    //查询当前人信息
    server.cache.getList('1', 'user', { where: "#{id}==" + req.user_id }, function (err, users) {
        if (err) {
            self.onLogicError(4, err.message, req);
            return;
        }
        var user = users[0];
        self.login(req, res, user);
    });
};

//模拟登录
UploadAttachByWPS.prototype.login = function (req, res, user) {
    var self = this;
    var loginname = user.loginname;
    var password = user.password;
    var body = {};
    body.loginname = loginname;
    body.password = password;
    body.clientType = 'web';
    body.ts = new Date().getTime();

    var ivData = [body.loginname, body.password, body.clientType, body.ts];
    var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
    ivData.push(iv);
    var key = utils.md5(JSON.stringify(ivData));
    body.data = utils.encryptAES(JSON.stringify(ivData), key, iv);
    body.app = 'sys';
    body.service = 'login';
    self.options["body"] = JSON.stringify(body);
    request(self.options, function (error, response) {
        if (error) throw new Error(error);
        var resp = JSON.parse(response.body);
        //解析登录成功后的data，获取org_code, org_key, user_id
        var ivData = [body.loginname, body.password, 'web', resp.ts];
        var iv = utils.md5(JSON.stringify(ivData)).substr(0, 16);
        ivData.push(iv);
        var key = utils.md5(JSON.stringify(ivData));
        var data = utils.decryptAES(resp.data, key, iv);
        var authData = JSON.parse(data);
        req.sessionId = resp.sessionId;
        req._auth_org = authData[0];
        req._auth_ts = new Date().getTime();
        self.getAuthData(req, authData, password, function (_auth_data) {
            req._auth_data = _auth_data;
            var uploadBody = {};
            uploadBody.app = 'sys';
            uploadBody.service = 'app/updateAttachByHttp.js';
            uploadBody.oriCode = req.oriCode;
            uploadBody._auth_retain = req._auth_retain;
            uploadBody.fileName = req.fileName;
            uploadBody.fileCode = req.fileCode;
            uploadBody.fileSize = req.fileSize;
            if (req.app_name) uploadBody.app_name = req.app_name;
            if (req.work_id) uploadBody.work_id = req.work_id;
            uploadBody.sessionId = resp.sessionId;
            uploadBody._auth_org = authData[0];
            uploadBody._auth_ts = new Date().getTime();
            uploadBody._auth_data = _auth_data;
            self.options["body"] = JSON.stringify(uploadBody);
            request(self.options, function (error, response) {
                if (error) {
                    res.code = 2;
                    res.message = '保存文件失败，请稍后再试！';
                    self.end(res);
                    return;
                }
                var resp = JSON.parse(response.body);
                self.end(resp);
            });
        });
    });
}

//获取service的_auth_data
UploadAttachByWPS.prototype.getAuthData = function (req, authData, password, cb) {
    var signData = [authData[0], authData[2], req._auth_ts];
    var iv = utils.md5(JSON.stringify(signData)).substr(0, 16);
    signData.push(iv);
    var key = utils.md5(JSON.stringify(signData));
    var loginData = ['userid', authData[1], 'web'];
    signData.push(password);
    loginData.push(utils.md5(JSON.stringify(signData)).toString());
    var _auth_data = utils.encryptAES(JSON.stringify(loginData), key, iv);
    cb(_auth_data)
}
