var util = require('util');
var http = require('http');
var fs = require('fs') ;
var path = require('path');
var uuid = require('node-uuid');
var Service = require('Service');
var utils = require('utils');
var Session = require('Session');
var AppAttachDao = require('../../dao/app_attach');

/**
 * 上传附件
 */
var UploadAttachByHttp = function() { 
  Service.call(this);
  this.attachDao = new AppAttachDao(this);
  this.checkAuthority = false;
};

util.inherits(UploadAttachByHttp, Service);

module.exports = UploadAttachByHttp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UploadAttachByHttp.prototype.process =  function(req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/uploadAttachByHttp'), req, res);
    return;
  }
  if(!req.appCode) {
    this.onLogicError(1, '请提供应用编码！', req);
    return;
  }
  //必须校验应用编码和文件编码的格式，否则可能会被黑客发送非法的路径进行攻击
  var reg1 = /^[a-zA-Z]([_.a-zA-Z0-9]{1,30})$/;
  if (!reg1.test(req.appCode)) {
    this.onLogicError(1, '应用编码格式无效！', req, res);
    return;
  }
  if(!req.fileCode) {
    this.onLogicError(2, '请提供文件编码！', req);
    return;
  }
  var reg2 = /^([a-zA-Z0-9]{32})$/;
  if (!reg2.test(req.fileCode)) {
    this.onLogicError(1, '文件编码格式无效！', req, res);
    return;
  }
  if(!req.fileName) {
    this.onLogicError(3, '请提供文件名！', req);
    return;
  }
  if(!req.fileSize) {
    this.onLogicError(4, '请提供文件大小！', req);
    return;
  }
  
  var self = this;
  //创建文件保存路径
  var relativePath = '/'+req.session.orgCode+'/';
  var absolutePath = path.join(server.attachSavePath, relativePath);
  if(!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);
  relativePath += req.appCode+'/';
  absolutePath = path.join(server.attachSavePath, relativePath);
  if(!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);
  relativePath += utils.formatDate(new Date(), 'yyyy_MM')+'/';
  absolutePath = path.join(server.attachSavePath, relativePath);
  if(!fs.existsSync(absolutePath)) fs.mkdirSync(absolutePath);

  var ext = path.extname(req.fileName);
  req.ext = ext;
  if(req.retainExt && (ext=='.mp4' || ext=='.mp3' || ext=='.amr' 
    ||ext=='.jpg' || ext=='.png' || ext=='.gif')) {
    relativePath += req.fileCode+path.extname(req.fileName);
  } else {
    relativePath += req.fileCode+'.file';
  }
  absolutePath = path.join(server.attachSavePath, relativePath);
  console.log('文件路径：'+absolutePath);

  req.tmpPath = utils.formatPath(server.attachSavePath+'/tmp/upload_'+req.fileCode);
  //如果要压缩图片
  if(server.config.Attach.compressImage && req.compressImage) {
    this.compressImage(req, res, relativePath, absolutePath);
  } else {
    this.moveFile(req, res, relativePath, absolutePath);
  }
};

/**
 * 移动临时文件到应用附件目录
 * @param {*} req 
 * @param {*} res 
 * @param {*} relativePath 
 * @param {*} absolutePath 
 */
UploadAttachByHttp.prototype.moveFile = function(req, res, relativePath, absolutePath) {
  var self = this;
  fs.rename(req.tmpPath, utils.formatPath(absolutePath), function() {
    self.delDuplicateFile(req, res, relativePath);
  });
};

/**
 * 压缩图片
 * @param {*} req 
 * @param {*} res 
 * @param {*} relativePath 
 * @param {*} absolutePath 
 */
UploadAttachByHttp.prototype.compressImage = function(req, res, relativePath, absolutePath) {
  var self = this;
  var gm = require('gm');
  var imageTemp = gm(req.tmpPath);
  imageTemp.size(function (err, size) {
    if (err) {
      self.onLogicError(11, '获得图片尺寸时发生意外错误：' + err.message, req);
      return;
    } 

    let maxSize = 960;
    if(req.maxSize) maxSize = parseInt(req.maxSize);

    //如果图片大小没有超过最大尺寸，则不需要压缩，直接从临时文件夹移动到目标文件夹即可
    if(size.width<=maxSize && size.height<=maxSize) {
      self.moveFile(req, res, relativePath, absolutePath);
      return;
    }

    console.log('正在压缩图片...');

    let imgWidth = maxSize;
    let imgHeight = maxSize;

    var imageSize = size.width;
    //如果宽度大于高度，则宽度改为最大值，高度等比例缩小
    if (size.width > size.height) {
      imgHeight = parseInt(size.height * 960/size.width);
    } else if (size.width < size.height) {
      imgWidth = parseInt(size.width * 960/size.height);
    }
    imageTemp = imageTemp.resize(imgWidth, imgHeight);
    //console.log(utils.formatPath(absolutePath+req.ext));
    //转换格式时，文件扩展名需要保留
    imageTemp.write(utils.formatPath(absolutePath+req.ext), function (err2) {
      if (err2) {
        self.onLogicError(12, '压缩图片时发生意外错误：' + err2.message, req);
        return;
      }
      //转换完之后，再去掉扩展名
      fs.rename(utils.formatPath(absolutePath+req.ext), utils.formatPath(absolutePath), function() {
        //删除临时文件
        fs.unlink(req.tmpPath, function(err3) {
          if (err3) {
            self.onLogicError(13, '删除临时文件时发生意外错误：' + err3.message, req);
            return;
          }
          self.delDuplicateFile(req, res, relativePath);
        });
      });
    });
  });
}

/**
 * 删除重复文件
 * @param {*} req 
 * @param {*} res 
 * @param {*} relativePath 
 */
UploadAttachByHttp.prototype.delDuplicateFile = function(req, res, relativePath) {
  var self = this;
  if(req.appDataId && req.appDataId>0 && req.onlyOne) {
    self.attachDao.delete('app_code=\''+req.appCode+'\' and app_data_Id='
      +req.appDataId+' and org_id='+req.session.orgId, function() {
        self.addAttach(req, res, relativePath);
    });
  } else {
    self.addAttach(req, res, relativePath);
  }
};

/**
 * 添加附件信息
 * @param {*} req 
 * @param {*} res 
 * @param {*} relativePath 
 */
UploadAttachByHttp.prototype.addAttach =  function(req, res, relativePath) {
  var self = this;
  var attach = {};
  attach.code = req.fileCode;
  attach.name = req.fileName;
  attach.size = req.fileSize;
  attach.type = path.extname(req.fileName);
  attach.app_code = req.appCode;
  if(req.appDataId && req.appDataId>0) attach.app_data_id = req.appDataId;
  attach.uploader_id = req.session.userId;
  attach.uploader_name = req.session.userName;
  attach.upload_time = new Date();
  attach.save_path = relativePath;
  attach.org_id = req.session.orgId;
  if(req.enIde) attach.en_ide = req.enIde;
  
  this.attachDao.create(attach, function(ret) {
    if(req.appCode=='KindEditor') {
      res.error = 0;
      //res.url = '/TaskMsgDownload?sessionId='+req.session.id+'&fileCode='+req.fileCode;
      res.url = '/TaskMsgDownload?fileCode='+req.fileCode;
    } else if(req.appCode=="CKEditor") {
      res.uploaded = 1;
      res.url = '/TaskMsgDownload?sessionId='+req.session.id+'&fileCode='+req.fileCode;
      res.fileName  = req.fileName;
    } else {
      res.fileCode = req.fileCode;
      res.fileSize = req.fileSize;
      res.fileName = req.fileName;
      res.fileId = ret.insertId;
    }
    attach.id = ret.insertId;
    self.end(res);
  });
};