var util = require('util');
var fs = require('fs');
var path = require('path');
var Service = require('Service');
var utils = require('utils');
var AppAttachDao = require('../../dao/app_attach');
var Dao_wjxx = require('../../../oa/dao/oa_netdisk_file');
var Dao_version = require('../../../oa/dao/oa_netdisk_version');
var Dao = require('Dao');

/**
 * 上传附件
 */
var UpdateAttachByHttp = function () {
  Service.call(this);
  this.attachDao = new AppAttachDao(this);
  this.checkLogin = false;
  this.checkAuthority = false;
  this.timestampTimeout = 1 * 60 * 60;
};

util.inherits(UpdateAttachByHttp, Service);

module.exports = UpdateAttachByHttp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
UpdateAttachByHttp.prototype.process = function (req, res, cb) {
  if (!req.oriCode) {
    this.onLogicError(1, '请提供原始文件编码！', req, res, cb);
    return;
  }
  if (!req.fileCode) {
    this.onLogicError(2, '请提供文件编码！', req, res, cb);
    return;
  }
  if (!req.fileSize) {
    this.onLogicError(3, '请提供文件大小！', req, res, cb);
    return;
  }
  if (!req.auth_code) {
    this.onLogicError(4, '请提供身份信息！', req, res, cb);
    return;
  }

  var self = this;
  self.authArray = JSON.parse(utils.decryptDES(req.auth_code, "task@msg"));
  if (!self.authArray || self.authArray.length < 4) {
    this.onLogicError(3, '请提供正确的身份信息！', req, res, cb);
    return;
  }
  req.org_id = self.authArray[0];
  req.org_code = self.authArray[1];
  req.user_id = self.authArray[2];
  req.user_name = self.authArray[3];
  //公共文档
  if (req.app_name == 'netdisk_public') {
    this.pipe(require('../../../oa/service/netdisk/public/getSetting.js'), req, res, function (data) {
      if (data.open_version == 0) {
        //未开启版本控制
        self.updateAttach(req, function () {
          self.updateNetdiskFile(req, function () {
            if (cb) {
              cb(req, res);
            } else {
              self.end(res);
            }
          })
        })
      } else {
        //开启版本控制
        self.addNetdiskFile(req, function () {
          if (cb) {
            cb(req, res);
          } else {
            self.end(res);
          }
        })
      }
    })
  }
  //个人文档
  else if (req.app_name == 'netdisk_personal') {
    self.updateAttach(req, function () {
      self.updateNetdiskFile(req, function () {
        if (cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      })
    });
  }
  //wps文档转PDF
  else if (req.app_name == 'wf_work_doc_pdf') {
    if (!req.work_id) {
      this.onLogicError(5, '请提供工作编号！', req, res, cb);
      return;
    }
    if (!req.work_handle_id) {
      this.onLogicError(6, '请提供办理编号！', req, res, cb);
      return;
    }
    self.checkUploadAuth(req, function (auth) {
      if (!auth) {
        if (cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
        return;
      }
      self.updateWorkPdf(req, function () {
        if (cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      });
    });
  }
  //wps
  else {
    if (!req.work_handle_id) {
      this.onLogicError(6, '请提供办理编号！', req, res, cb);
      return;
    }
    self.checkUploadAuth(req, function (auth) {
      if (!auth) {
        if (cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
        return;
      }
      self.updateAttach(req, function () {
        if (cb) {
          cb(req, res);
        } else {
          self.end(res);
        }
      });
    });
  }
};

//验证是否有上传文档权限
UpdateAttachByHttp.prototype.checkUploadAuth = function (req, cb) {
  var self = this;
  var dao = new Dao(this);
  dao.execute('select work_id,flow_id,step_type,step_order,work_step_status,work_handle_status from wf_work_handle where org_id=? and id=? and status=0',
    [req.org_id, req.work_handle_id], function (rows) {
      if (rows.length == 0) {
        cb(false);
        return;
      }
      var object = rows[0];
      if (!['01', '02'].includes(object.work_step_status)) return cb(false);
      if (!['01', '02'].includes(object.work_handle_status)) return cb(false);
      if (['01', '02'].includes(object.work_step_status) && ['01', '02'].includes(object.work_handle_status)) {
        dao.execute('select file_param from wf_flow_step where org_id=? and flow_id=? and step_type=? and step_order=? and step_status=0',
          [req.org_id, object.flow_id, object.step_type, object.step_order], function (rows) {
            if (rows.length == 0) return cb(false);
            var file_param = JSON.parse(rows[0].file_param);
            if (req.app_name == 'wf_work_file') {
              if (file_param.file_write_sign || file_param.file_upload_sign) {
                return cb(true);
              } else {
                return cb(false);
              }
            } else {
              if (file_param.doc_upload_sign) {
                return cb(true);
              } else {
                return cb(false);
              }
            }
          });
      }
    });
}

UpdateAttachByHttp.prototype.updateWorkPdf = function (req, cb) {
  var self = this;
  this.attachDao.query({
    fields: '*',
    where: 'org_id=? and app_code=? and app_data_id=?',
    params: [req.org_id, 'wf_work_doc_pdf', req.work_id]
  }, function (rows) {
    if (rows.length > 0) {
      var attObj = rows[0];
      //创建文件保存路径
      var relativePath = attObj.save_path;
      var absolutePath = path.join(server.attachSavePath, relativePath);
      logger.log('文件路径：' + absolutePath);

      attObj.uploader_id = req.user_id;
      attObj.uploader_name = req.user_name;
      attObj.size = req.fileSize;
      attObj.upload_time = new Date();
      attObj.status = 0;
      self.attachDao.update(attObj, {
        where: 'id=?',
        params: [attObj.id]
      }, function () {
        var tmpPath = server.attachSavePath + '/tmp/upload_' + req.fileCode;
        fs.rename(utils.formatPath(tmpPath), utils.formatPath(absolutePath), function () {
          cb();
        });
      });
    } else {
      //创建文件保存路径
      var rootpath = server.attachSavePath;
      var filepath = '/' + req.org_code + '/exportFiles/wf_work_doc_pdf/';
      if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
      filepath += utils.formatDate(new Date(), 'yyyy_MM') + '/';
      if (!fs.existsSync(path.join(rootpath, filepath))) fs.mkdirSync(path.join(rootpath, filepath));
      filepath += req.fileCode + '.file';

      var obj_attach = {
        code: req.fileCode,
        name: req.fileName,
        size: req.fileSize,
        type: path.extname(req.fileName),
        app_code: 'wf_work_doc_pdf',
        app_data_id: req.work_id,
        uploader_id: req.user_id,
        uploader_name: req.user_name,
        upload_time: new Date(),
        save_path: filepath.replace(/\\/g, '/'),
        org_id: req.org_id,
        status: 0
      }
      self.attachDao.create(obj_attach, function (ret) {
        var tmpPath = server.attachSavePath + '/tmp/upload_' + req.fileCode;
        fs.rename(utils.formatPath(tmpPath), utils.formatPath(server.attachSavePath + filepath), function () {
          cb();
        });
      });
    }
  });
}

UpdateAttachByHttp.prototype.updateAttach = function (req, cb) {
  var self = this;
  var attObj = null;
  this.attachDao.query({
    fields: '*',
    where: "code=?",
    params: [req.oriCode]
  }, function (rows) {
    if (rows.length == 0) {
      this.onLogicError(4, '原始文件不存在！', req);
      return;
    }
    attObj = rows[0];
    if (req.onlySelf && attObj.uploader_id != req.user_id) {
      this.onLogicError(4, '您无权修改改文件！', req);
      return;
    }
    //创建文件保存路径
    var relativePath = attObj.save_path;
    var absolutePath = path.join(server.attachSavePath, relativePath);
    console.log('文件路径：' + absolutePath);

    attObj.uploader_id = req.user_id;
    attObj.uploader_name = req.user_name;
    attObj.size = req.fileSize;
    attObj.upload_time = new Date();
    attObj.status = 0;
    self.attachDao.update(attObj, {
      where: 'id=?',
      params: [attObj.id]
    }, function () {
      var tmpPath = server.attachSavePath + '/tmp/upload_' + req.fileCode;
      fs.rename(utils.formatPath(tmpPath), utils.formatPath(absolutePath), function () {
        cb();
      });
    });
  });
}

UpdateAttachByHttp.prototype.addNetdiskFile = function (req, cb) {
  var self = this;
  var dao = new Dao_wjxx(this);
  var dao_version = new Dao_version(this);

  //创建文件保存路径
  var rootpath = server.attachSavePath;
  var filepath = '/' + req.org_code + '/file_public/';
  if (!fs.existsSync(rootpath + filepath)) fs.mkdirSync(rootpath + filepath);
  filepath += utils.formatDate(new Date(), 'yyyy_MM') + '/';
  if (!fs.existsSync(rootpath + filepath)) fs.mkdirSync(rootpath + filepath);
  filepath += req.fileCode + '.file';

  dao.query({
    fields: 'id,name,filetype,last_version,(select id from oa_netdisk_version where file_id=oa_netdisk_file.id and version=oa_netdisk_file.last_version) as version_id',
    where: 'org_id=? and com_id=? and filecode=?',
    params: [req.org_id, req.companyId, req.oriCode]
  }, function (fileRows) {
    dao_version.query({
      fields: 'version',
      where: 'org_id=? and com_id=? and file_id=?',
      params: [req.org_id, req.companyId, fileRows[0].id],
      order: 'version desc'
    }, function (versionRows) {
      var new_version = parseInt(versionRows[0].version) + 1;
      var obj_version = {
        org_id: req.org_id,
        com_id: req.companyId,
        file_id: fileRows[0].id,
        version: new_version,
        name: fileRows[0].name,
        filecode: req.fileCode,
        filetype: fileRows[0].filetype,
        filesize: req.fileSize,
        creater_id: req.user_id,
        create_time: new Date()
      }
      dao_version.create(obj_version, function (ret) {
        var version_id = ret.insertId;
        var obj = {
          filecode: req.fileCode,
          filesize: req.fileSize,
          last_modify_time: new Date(),
          last_modifier_id: req.user_id,
          last_version: new_version
        }
        dao.update(obj, {
          where: 'org_id=? and id=? and com_id=?',
          params: [req.org_id, fileRows[0].id, req.companyId]
        }, function () {
          var obj_attach = {
            code: req.fileCode,
            name: fileRows[0].name,
            size: req.fileSize,
            type: fileRows[0].filetype,
            app_code: 'file_public',
            app_data_id: version_id,
            uploader_id: req.user_id,
            uploader_name: req.user_name,
            upload_time: new Date(),
            save_path: filepath.replace(/\\/g, '/'),
            org_id: req.org_id,
            status: 0
          }
          self.attachDao.create(obj_attach, function (ret) {
            req.operateType = "重新上传";
            req.fileId = fileRows[0].id;
            req.operateContent = req.user_name + '重新上传了文件' + '"' + fileRows[0].name + '"';
            self.pipe(require("../../../oa/service/netdisk/public/addLog.js"), req, null, function () {
              var tmpPath = server.attachSavePath + '/tmp/upload_' + req.fileCode;
              fs.rename(utils.formatPath(tmpPath), utils.formatPath(server.attachSavePath + filepath), function () {
                cb();
              });
            })
          })
        })
      })
    })
  })
}

UpdateAttachByHttp.prototype.updateNetdiskFile = function (req, cb) {
  var self = this;
  var dao = new Dao_wjxx(this);
  var dao_version = new Dao_version(this);
  var obj = {
    filesize: req.fileSize,
    last_modify_time: new Date(),
    last_modifier_id: req.user_id
  }
  dao.query({
    fields: 'id,name,last_version,(select id from oa_netdisk_version where file_id=oa_netdisk_file.id and version=oa_netdisk_file.last_version) as version_id',
    where: 'org_id=? and com_id=? and filecode=?',
    params: [req.org_id, req.companyId, req.oriCode]
  }, function (rows) {
    var file_id = rows[0].id;
    var file_name = rows[0].name;
    var version_id = rows[0].version_id;
    if (version_id && version_id > 0) {
      dao.update(obj, {
        where: 'org_id=? and id=? and com_id=?',
        params: [req.org_id, file_id, req.companyId]
      }, function () {
        var obj_version = {};
        obj_version.filesize = req.fileSize;
        dao_version.update(obj_version, {
          where: 'org_id and com_id=? and id=?',
          params: [req.org_id, req.companyId, version_id]
        }, function () {
          if (req.app_name == 'netdisk_public') {
            req.fileId = file_id;
            req.operateType = "重新上传";
            req.operateContent = req.user_name + '重新上传了文件' + '"' + file_name + '"';
            self.pipe(require("../../../oa/service/netdisk/public/addLog.js"), req, null, function () {
              cb();
            })
          } else {
            cb();
          }
        })
      })
    } else {
      dao.update(obj, {
        where: 'org_id=? and id=? and com_id=?',
        params: [req.org_id, file_id, req.companyId]
      }, function () {
        if (req.app_name == 'netdisk_public') {
          req.fileId = file_id;
          req.operateType = "重新上传";
          req.operateContent = req.user_name + '重新上传了文件' + '"' + file_name + '"';
          self.pipe(require("../../../oa/service/netdisk/public/addLog.js"), req, null, function () {
            cb();
          })
        } else {
          cb();
        }
      })
    }
  })
}
