var util = require('util');
var fs = require('fs');
var Service = require('Service');
var utils = require('utils');

/**
 * 导入Text数据
 */
var ImportText = function () {
  Service.call(this);
};

util.inherits(ImportText, Service);

module.exports = ImportText;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
ImportText.prototype.process = function (req, res, cb) {
  if (!req.fileCode) {
    this.onLogicError(1, '请提供Excel文件代码！');
    return;
  }
  var filePath = server.attachSavePath + '/tmp/upload_' + req.fileCode;
  logger.log('正在解析Text文件：' + filePath);
  if (!fs.existsSync(filePath)) {
    this.onLogicError(2, '文件不存在，请提供正确的文件代码！', req, res, cb);
    return;
  }

  res.text = fs.readFileSync(filePath).toString();
  fs.unlinkSync(filePath);
  if (cb) {
    cb(req, res);
  } else {
    this.end(res);
  }
};