var util = require('util');
var fs = require('fs');
var xlsx = require('node-xlsx');
var Service = require('Service');
var utils = require('utils');

/**
 * 导入Excel数据
 */
var ImportExcel = function () {
    Service.call(this);
    //this.checkLogin = false;
};

util.inherits(ImportExcel, Service);

module.exports = ImportExcel;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
ImportExcel.prototype.process = function (req, res, cb) {
    if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
        this.pipe(require('../../../system/service/importExcel'), req, res);
        return;
    }
    if (req.options) {
        if (!req.options.fileCode) {
            this.onLogicError(1, '请提供文件代码！');
            return;
        }
        //如果有已经解析完的数据，则直接导入
        if (req.data) {
            this.import(req, res, obj[0].data, cb);
        } else {
            this.parse(req, res, req.options.fileCode, cb);
        }
    } else if (req.fileCode) {
        this.parse(req, res, req.fileCode, cb);
    } else {
        this.onLogicError(1, '请提供导入配置信息！');
    }
};

ImportExcel.prototype.parse = function (req, res, fileCode, cb) {
    var filePath = server.attachSavePath + '/tmp/upload_' + fileCode;
    if (!fs.existsSync(filePath)) {
        this.onLogicError(2, '文件不存在，请提供正确的文件代码！');
        return;
    }
    logger.log('正在解析Excel文件：' + filePath);
    var obj;
    try {
        obj = xlsx.parse(filePath);
    } catch (err) {
        this.onLogicError(3, '解析Excel文件失败！');
        return;
    }
    //删除临时文件
    /*try {
      fs.unlinkSync(filePath);
    } catch(err) {}*/
    if (obj.length == 0) {
        this.onLogicError(4, '未解析到有效的单元格！');
        return;
    }

    if (req.options) {
        this.import(req, res, obj[0].data, cb);
    } else if (req.fileCode) {
        res.data = obj[0].data;
        if (cb) {
            cb(req, res);
        } else {
            this.end(res);
        }
    } else {
        this.end(res);
    }
};

ImportExcel.prototype.import = function (req, res, data, cb) {
    req.options.titleRowIndex = parseInt(req.options.titleRowIndex);
    if (data.length < req.options.titleRowIndex) {
        this.onLogicError(5, '未解析到标题行！');
        return;
    }
    if (data.length == req.options.titleRowIndex) {
        this.onLogicError(6, '未解析到数据！');
        return;
    }
    logger.log("共解析到" + (data.length - req.options.titleRowIndex) + "条记录，正在准备导入...");
    var self = this;
    let model = server.loadModule(req.options.model.path);
    var Dao = null, ds = null;
    if (model.dsId) {
        ds = server.getDataSource(model.dsId);
        Dao = require("Dao_" + ds.type);
    } else {
        Dao = require("Dao");
    }
    this._dao = new Dao();
    this._dao.model = model;
    if (this._dao.model.dsId) {
        this._dao.setConfig(ds);
    }
    this._dao.bindService = false;
    this._dao.autoConnected = false;
    this._dao.enableTransaction = false;
    this._importFields = {};
    this._pkFields = [];
    let count = 0;
    var titleCols = data[req.options.titleRowIndex - 1];
    var needCheckFields = [];
    for (var index = 0; index < req.options.fields.length; index++) {
        let field = req.options.fields[index];
        //如果字段设置了不能为空或者可选项，则加入待校验列表，后面会对该字段的数据进行相关校验
        if (field.options || field.notNull) needCheckFields.push(index);
        //查找导入字段在Excel里对应的列索引
        field.colIndex = -1
        for (var i = 0; i < titleCols.length; i++) {
            if (titleCols[i] == field.column) {
                field.colIndex = i;
                break;
            }
        }

        //如果Excel中没有找到对应的列
        if (field.colIndex == -1) {
            if (field.key) {
                self.onLogicError(7, '缺少主键列[' + field.column + ']，无法判断数据记录是否已存在！');
                return;
            }
            //如果没有设置默认值或格式化表达式，则不导入该字段数据
            if (!field.value && !field.format) continue;
        }

        //从数据模型中查找字段的数据类型，以便进行数据格式化
        for (let fieldName in self._dao.model.fields) {
            if (fieldName == field.field) {
                field.type = self._dao.model.fields[fieldName].type;
                break;
            }
        }
        self._importFields[field.field] = field;
        if (field.key) self._pkFields.push(field.field);
        count++;
    }
    if (count == 0) {
        this.onLogicError(8, '未解析到有效的表格标题，请确认表格格式是否与导入设置一致！');
        return;
    }
    if (req.options.onlyUpdate && self._pkFields.length == 0) {
        this.onLogicError(9, '请设置主键列！');
        return;
    }
    //如果字段限定了可选项，或者不能为空，则需要判断Excel数据是否满足要求
    if (needCheckFields.length > 0) {
        for (var i = parseInt(req.options.titleRowIndex); i < data.length; i++) {
            for (var j = 0; j < needCheckFields.length; j++) {
                var field = req.options.fields[needCheckFields[j]];
                var cellData = data[i][field.colIndex];
                if (field.notNull && (!cellData || (cellData + "").trim() == "") && !field.value && field.value != 0) {
                    this.onLogicError(10, field.column + '不能为空！');
                    return;
                }
                //如果列设置了可选项，则该列的值只能在这些可选项的范围内
                if (field.options && (cellData || cellData == 0) && !field.options.contains(cellData)) {
                    this.onLogicError(10, field.column + '的值不能为' + cellData + '！');
                    return;
                }
            }
        }
    }
    this._dao.open(function () {
        //如果没有设置主键，或者只需要更新，不需要插入，则直接执行导入，不需要查询主键值
        if (self._pkFields.length == 0 || req.options.onlyUpdate) {
            self._keys = [];
            self.exeImport(req, res, data, index, cb);
        } else {
            self._dao.query({ fields: self._pkFields.join(",") }, function (keys) {
                self._keys = keys;
                self.exeImport(req, res, data, index, cb);
            });
        }
    });
};

ImportExcel.prototype.exeImport = function (req, res, data, index, cb) {
    //开启后台运行
    var self = this;
    this.runInBackground(res);
    this._dao.onError = function (err) {
        self.onImportError(req, err.message, cb);
    };
    this.serviceInfo = server.tmpBGServices[this.id];
    this.serviceInfo.total = data.length - req.options.titleRowIndex;
    this.serviceInfo.finish = 0;
    this.importRow(req, res, data, parseInt(req.options.titleRowIndex), cb);
};

ImportExcel.prototype.importRow = function (req, res, data, index, cb) {
    if (index > req.options.titleRowIndex) this.serviceInfo.finish++;
    if (index >= data.length) {
        logger.log("导入完毕。");
        this._importFields = null;
        this._pkFields = null;
        this._keys = null;
        this._dao.close();
        server.tmpBGServices[this.id].status = 1;
        if (cb) {
            cb(data);
        } else {
            data = null;
            this.end(res);
        }
        return;
    }

    let rowData = data[index];

    //如果定义了处理每行数据的后台服务，则调用该服务进行处理
    if (req.options.processRowDataService) {
        const self = this;
        req.rowIndex = index;
        req.rowData = rowData;
        this.pipe(server.loadModule('/app/' + req.options.processRowDataService), req, res, function (reqPipe, resPipe) {
            //如果要忽略该行，则继续处理下一行
            if (resPipe.ignore) {
                res.ignore = null;
                self.importRow(req, res, data, index + 1, cb);
            } else {  //否则表示该行数据有效，则执行实际的导入处理
                self.exeImportRow(req, res, data, index, reqPipe.rowData, cb);
            }
        });
    } else {
        this.exeImportRow(req, res, data, index, rowData, cb);
    }
};

ImportExcel.prototype.exeImportRow = function (req, res, data, index, dataRow, cb) {
    //生成当前行判断是否记录已存在的查询条件
    let pkWhere = "";
    for (var i = 0; i < this._pkFields.length; i++) {
        if (i > 0) pkWhere += " and ";
        let keyFieldName = this._pkFields[i];
        let keyField = this._importFields[keyFieldName];
        pkWhere += " " + keyFieldName + "=";
        let pkData = dataRow[keyField.colIndex];
        if (keyField.dataType == '日期') pkData = this.formatDate(pkData).format('yyyy-MM-dd');
        //如果主键字段为空，则不处理该行
        if (!pkData || pkData == "") {
            this.importRow(req, res, data, index + 1, cb);
            return;
        }
        if (keyField.type == "int" || keyField.type == "float"
            || keyField.type == 'double' || keyField.type == 'numeric') {
            pkWhere += pkData;
        } else {
            pkWhere += "'" + pkData + "'";
        }
    }

    //如果只需要更新
    if (req.options.onlyUpdate) {
        this.updateRow(req, res, data, dataRow, pkWhere, index, cb);
        return;
    }

    let isExists = false;
    for (var i = 0; i < this._keys.length; i++) {
        let keyRow = this._keys[i];
        let isMatch = true;
        for (var j = 0; j < this._pkFields.length; j++) {
            let keyFieldName = this._pkFields[j];
            let keyField = this._importFields[keyFieldName];
            let keyVal1 = keyRow[keyFieldName];
            let keyVal2 = dataRow[keyField.colIndex];
            if (keyField.dataType == '日期') {
                if (keyVal1) keyVal1 = new Date(keyVal1).format('yyyy-MM-dd');
                if (keyVal2) keyVal2 = this.formatDate(keyVal2);
                if (keyVal2) keyVal2 = keyVal2.format('yyyy-MM-dd');
            }
            if (keyVal1 != keyVal2) {
                isMatch = false;
                break;
            }
        }
        if (isMatch) {
            isExists = true;
            break;
        }
    }
    //如果记录不存在，则直接插入
    if (!isExists) {
        this.insertRow(req, res, data, dataRow, index, true, cb);
        return;
    }
    //如果是删除重建
    if (parseInt(req.options.importType) == 2) {
        var self = this;
        this._dao.delete({ where: pkWhere }, function () {
            self.insertRow(req, res, data, dataRow, index, false, cb);
        });
    } else if (parseInt(req.options.importType) == 1) {
        this.updateRow(req, res, data, dataRow, pkWhere, index, cb);
    } else {  //否则，忽略该条记录
        this.importRow(req, res, data, index + 1, cb);
    }
};

/**
 * 根据数据模型中的字段数据类型，对导入的数据进行格式化
 * @param {*} field 
 * @param {*} cellData 
 * @returns 
 */
ImportExcel.prototype.formatData = function (field, cellData) {
    if ((!cellData && cellData != 0) || (cellData + "").trim() == "") {
        return null;
    }
    if (utils.isDate(cellData)) return cellData;
    if (field.type == "datetime" || field.type == 'date') {
        return this.formatDate(cellData);
    } else if (field.type == "int") {
        cellData = parseInt(cellData);
        if (isNaN(cellData)) return null;
        return cellData;
    } else if (field.type == "float" || field.type == "double" || field.type == "numeric") {
        cellData = parseFloat(cellData);
        if (isNaN(cellData)) return null;
        return cellData;
    } else {
        return cellData + "";
    }
};

/**
 * 添加新纪录
 * @param {*} req 
 * @param {*} res 
 * @param {*} data 
 * @param {*} dataRow 
 * @param {*} index 
 * @param {*} isNew 
 * @param {*} cb 
 * @returns 
 */
ImportExcel.prototype.insertRow = function (req, res, data, dataRow, index, isNew, cb) {
    var newData = {};
    var newKey = {};
    var rowData = {};
    //将当前行的数据存入一个json对象，以便下面格式化时进行替换
    for (var fieldName in this._importFields) {
        let field = this._importFields[fieldName];
        rowData[fieldName] = dataRow[field.colIndex];
    }
    rowData._rowIndex = index;
    for (var fieldName in this._importFields) {
        let field = this._importFields[fieldName];
        let cellData = this.formatData(field, dataRow[field.colIndex]);
        //如果定义了数据格式化表达式
        if (field.format) {
            try {
                //替换同一行中其他字段的值
                cellData = utils.replaceDataField(rowData, field.format);
                //执行表达式
                cellData = eval(cellData);
                //格式化数据
                cellData = this.formatData(field, cellData);
            } catch (err) {
                //
            }
        }
        //如果值为空
        if ((!cellData && cellData != 0) || cellData == "") {
            //如果定义了默认值，则用默认值
            if (field.value || field.value == 0) {
                cellData = field.value;
            } else {
                continue;  //忽略空数据
            }
        }
        newData[fieldName] = cellData;
        if (field.key) newKey[fieldName] = cellData;
    }
    //如果设置了格式化数据行的函数，则调用该函数对数据进行格式化
    if (req.options.formatDataRow) newData = req.options.formatDataRow(newData);
    //如果设置了数据格式校验的函数，则调用该函数进行校验，如果不符合要求，则忽略
    if (req.options.checkDataRow && !req.options.checkDataRow(newData)) {
        this.importRow(req, res, data, index + 1, cb);
        return;
    }
    var self = this;
    try {
        this._dao.create(newData, function (arg1, err, arg2) {
            if (err) {
                self.onImportError(req, err.message, cb);
                return;
            }
            //将新加的行存入主键集合
            if (isNew && self._pkFields.length > 0) self._keys.push(newKey);
            self.importRow(req, res, data, index + 1, cb);
        });
    } catch (err) {
        this.onImportError(req, err.message, cb);
    }
};

/**
 * 更新行
 * @param {*} req 
 * @param {*} res 
 * @param {*} data 
 * @param {*} dataRow 
 * @param {*} where 
 * @param {*} index 
 * @param {*} cb 
 * @returns 
 */
ImportExcel.prototype.updateRow = function (req, res, data, dataRow, where, index, cb) {
    var newData = {};
    var count = 0;
    var rowData = {};
    //将当前行的数据存入一个json对象，以便下面格式化时进行替换
    for (var fieldName in this._importFields) {
        let field = this._importFields[fieldName];
        rowData[fieldName] = dataRow[field.colIndex];
    }
    rowData._rowIndex = index;
    for (var fieldName in this._importFields) {
        let field = this._importFields[fieldName];
        if (field.key) continue;
        let cellData = this.formatData(field, dataRow[field.colIndex]);
        //如果定义了数据格式化表达式
        if (field.format) {
            try {
                //替换同一行中其他字段的值
                cellData = utils.replaceDataField(rowData, field.format);
                //执行表达式
                cellData = eval(cellData);
                //格式化数据
                cellData = this.formatData(field, cellData);
            } catch (err) {
                //
            }
        }
        //如果值为空
        if ((!cellData && cellData != 0) || cellData == "") {
            //如果定义了默认值，则用默认值
            if (field.value || field.value == 0) {
                cellData = field.value;
            } else {
                if (!req.options.updateNullData) continue;  //忽略空数据
            }
        }
        newData[fieldName] = cellData;
        count++;
    }
    //如果没有任何可以修改的数据，则跳过该行
    if (count == 0) {
        this.importRow(req, res, data, index + 1, cb);
        return;
    }
    let options = {
        where: where
    };
    //如果设置了额外的修改条件，则需要附加到主键查询条件上
    if (req.options.updateWhere) options.where += " and " + utils.replaceDataField(newData, req.options.updateWhere);
    //如果设置了格式化数据行的函数，则调用该函数对数据进行格式
    if (req.options.formatDataRow) newData = req.options.formatDataRow(newData);
    //如果设置了数据格式校验的函数，则调用该函数进行校验，如果不符合要求，则忽略
    if (req.options.checkDataRow && !req.options.checkDataRow(newData)) {
        this.importRow(req, res, data, index + 1, cb);
        return;
    }
    var self = this;
    try {
        this._dao.update(newData, options, function (arg1, err, arg2) {
            if (err) {
                self.onImportError(req, err.message, cb);
                return;
            }
            self.importRow(req, res, data, index + 1, cb);
        });
    } catch (err) {
        this.onImportError(req, err.message, cb);
    }
};

/**
 * 格式化日期值
 * @param {*} data 
 * @returns 
 */
ImportExcel.prototype.formatDate = function (data) {
    if (typeof (data) == "string" && data.indexOf("-") > 0) {
        if (data.indexOf(":") > 0) {
            return new Date(data);
        } else if (data.indexOf("-") > 0 || data.indexOf("/") > 0) {
            return new Date(data + " 0:00:00");
        } else {
            return null;
        }
    } else if ((typeof (data) == "string" && data.indexOf(".") > 0)
        || (typeof data === 'number' && !isNaN(data))) {
        if (typeof (data) == "string") data = parseFloat(data);
        var date_num = parseInt(data);
        var time_num = data - date_num;
        var date = new Date(1900, 0, 1, 0, 0, 0);
        date.setDate(date_num - 1);
        if (time_num > 0) date.setSeconds(time_num * 60 * 60 * 24);
        return date;
    } else {
        return null;
    }
};

ImportExcel.prototype.onImportError = function (req, err, cb) {
    this._importFields = null;
    this._pkFields = null;
    this._keys = null;
    //if(this._dao.isConnected) this._dao.close();
    var res = { code: 500, message: err };
    var tmpBGService = server.tmpBGServices[this.id];
    tmpBGService.status = -1;
    tmpBGService.endTime = new Date();
    tmpBGService.error = res;
    if (cb) {
        cb(req, res);
    } else {
        this.end(res);
    }
};
