var util = require('util');
var fs = require('fs');
var cmd = require('child_process');
var Service = require('../../../../common/Service');
var AttachDao = require('../../dao/app_attach');
var utils = require('../../../../common/utils');

/**
 * 图片附件
 */
var ImageAttach = function () {
  Service.call(this);
  this.connectDb = false;
  this.checkAuthority = false;
};

util.inherits(ImageAttach, Service);

module.exports = ImageAttach;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
ImageAttach.prototype.process = function (req, res) {
  var self = this;
  var strWhere = '';
  req.socket.stopListen();
  if (req.fileId) {
    strWhere = 'id=' + req.fileId + ' and org_id=' + req.session.orgId;
  } else if (req.fileCode) {
    strWhere = 'code="' + req.fileCode + '"';
  } else if (req.appCode && req.appDataId) {
    strWhere = 'app_code="' + req.appCode + '" and app_data_id='
      + req.appDataId + ' and org_id=' + req.session.orgId;
  } else {
    this.onError(1, '请提供下载附件所需要的参数！', req);
    return;
  }
  var attachDao = new AttachDao(this);
  attachDao.query({
    fields: 'code,save_path,size',
    where: strWhere
  }, function (rows) {
    if (rows.length == 0) {
      self.onError(2, '未找到满足条件的附件！', req);
      return;
    }
    var fileCode = rows[0].code;
    var filePath = rows[0].save_path;
    var fileSize = rows[0].size;

    var path = process.cwd() + filePath.replace(/\//g, '/');
    if (req.mp3) {
      self.sendMp3File(req, res, fileCode, path, fileSize);
    } else {
      self.sendFile(req, res, fileCode, path, fileSize);
    }
  });
};

ImageAttach.prototype.sendMp3File = function (req, res, fileCode, filePath, fileSize) {
  var self = this;
  var mp3File = filePath + '.mp3';
  if (fs.existsSync(mp3File)) {
    fs.stat(mp3File, function (err, stats) {
      self.sendFile(req, res, fileCode, mp3File, stats.size);
    });
    return;
  }

  cmd.exec('ffmpeg -i ' + filePath + ' ' + mp3File, function (error, stdout, stderr) {
    if (error) {
      logger.log('将语音文件转换为MP3格式时发生意外错误：' + error.message, req._requestId);
      self.sendFile(req, res, fileCode, filePath, fileSize);
      return;
    }
    fs.stat(mp3File, function (err, stats) {
      self.sendFile(req, res, fileCode, mp3File, stats.size);
    });
  });
};

ImageAttach.prototype.sendFile = function (req, res, fileCode, filePath, fileSize) {
  if (!fs.existsSync(filePath)) {
    this.onError(3, '附件在服务器上不存在！', req);
    return;
  }
  logger.log('准备发送附件[' + fileCode + ']。', req._requestId);

  var readStream = null;
  if (req.start) {
    readStream = fs.createReadStream(filePath, { start: req.start, end: fileSize - 1 });
  } else {
    readStream = fs.createReadStream(filePath);
  }
  var self = this;
  readStream.on('end', function (err) {
    self.end(null);
    if (err) {
      logger.log('附件[' + fileCode + ']发送失败，错误描述：' + err.message, req._requestId);
      return;
    }
    logger.log('附件[' + fileCode + ']发送完毕。', req._requestId);
  });

  req.socket._socket.on('data', function () {
    try {
      readStream.pipe(req.socket._socket);
    } catch (err) {
      self.onError(4, '读取附件时发生意外错误！', req);
      return;
    }
  });

  //   var ret = '0 '+fileSize+'\r\n';  
  //   if(req.session && (req.session.clientType=='pc' || 
  //     (req.session.clientVersion && req.session.clientVersion.length>=2 
  //     && req.session.clientVersion.substr(0,2)!='0.')))
  //     ret = '{"code":0,"fileSize":'+fileSize+'}\r\n';

  var ret = '{"code":0,"fileSize":' + fileSize + '}\r\n';

  req.socket.write(ret, function (err) {
    if (err) {
      logger.log('发送附件时发生意外错误，错误描述：' + err.message, req._requestId);
      self.end(null);
      return;
    }
  });
}

ImageAttach.prototype.onError = function (code, message, req) {
  logger.log('附件发送失败，错误描述：' + code + ' ' + message, req._requestId);
  var self = this;
  var res = code + " " + message;
  if (req.session && (req.session.clientType == 'pc' ||
    (req.session.clientVersion && req.session.clientVersion.length >= 2
      && req.session.clientVersion.substr(0, 2) != '0.')))
    res = '{"code":' + code + ',"message":"' + message + '"}';

  req.socket.write(res, function () {
    self.end(null);
  });
};