var Service = require('Service');
var utils = require('utils');
var util = require('util');
var Dao = require('../../dao/vorg_app');
var AttachDao = require('../../dao/app_attach');

/**
 * 获得应用信息
 */
var Get = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  if(!req.appId) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if(!utils.isInt(req.appId)) {
    this.onLogicError(3, '请提供正确的应用编号！');
    return;
  }

  var self = this;
  req.session.cache.get('app', req.appId, function(err, app) { 	
    if(err) {
      self.onError(err);
      return;
    }
    var arr = app.terminal.split(',');
    res.list = [];
    for(var i=0;i<arr.length;i++) {
      var t = {
        id: arr[i]
      };
      if(t.id=='web') {
        t.name = 'Web端';
      } else if(t.id=='phone') {
        t.name = '手机客户端';
      } else if(t.id=='pc') {
        t.name = '电脑客户端';
      }
      res.list.push(t);
    }
    self.end(res);
  });
};