var util = require('util');
var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/app_opration');

var GetOprations = function() {
  Service.call(this);
};

util.inherits(GetOprations, Service);

module.exports = GetOprations;

GetOprations.prototype.process =  function(req, res) {
	if(!req.appId) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if(!utils.isInt(req.appId)) {
    this.onLogicError(2, '请提供正确的应用编号！');
    return;
  }

  var self = this;
  var dao = new Dao(this);
  dao.query({fields:'*', where:'app_id='+req.appId}, function(rows) {
    res.rows = rows;
    self.end(res);
  });
};