var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/vapp_auth');
var DaoC = require('../../dao/org_app_category');

/**
 * 获得当前用户可以访问的应用列表
 */
var GetMyAppsByCategory = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetMyAppsByCategory, Service);

module.exports = GetMyAppsByCategory;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetMyAppsByCategory.prototype.process =  function(req, res) {
  if(!req.categoryId) {
    this.onLogicError(1, '请提供应用分类编号！');
    return;
  }
  
  res.apps = {};
  res.categorys = [];

  var ctype = 'web';
  if(req.clientType) ctype = req.clientType.toLowerCase();

  var clientType = 'web';
  if(ctype=='pc'){
    clientType = 'pc';
  } else if(ctype.indexOf('phone')>=0){
    clientType = 'phone';
  } else if(ctype.indexOf('pad')>=0){
    clientType = 'pad';
  }

  var self = this;
  req.session.cache.exec({
    userId: req.session.userId,
    clientType: clientType,
    categoryId: req.categoryId
  }, function(cacheData, args) {
    var curUser = cacheData['user'].values[args.userId];
    //获得所有人角色
    var roleAllUser = null;
    for(roleId in cacheData['role'].values) {
      var role = cacheData['role'].values[roleId];
      if(role.name=='所有人') {
        roleAllUser = role;
        break;
      }
    }
    //获得应用权限信息
    var authsModel = cacheData['app_auth'];
    var auths = [];
    for(var j=0;j<authsModel.keys.length;j++) {
      var auth = authsModel.values[authsModel.keys[j]];
      if(!auth.opration_id && (!auth.terminal || auth.terminal.indexOf(args.clientType)>=0)) {
        auths.push({
          app_id: auth.app_id,
          owner_id: auth.owner_id,
          owner_type: auth.owner_type
        });
      }
    }

    var appModel = cacheData['app'];
    var categoryModel = cacheData['app_category'];
    var categoryKeys = categoryModel.keys;
    var rootCategory = categoryModel.values[args.categoryId];
    
    var ret = {
      categorys: {},
      apps: {},
      subCategorys: rootCategory.subCategorys,
      appIds: rootCategory.apps,
      user: {
        id: curUser.id,
        code: curUser.code,
        name: curUser.name,
        loginname: curUser.loginname,
        mobile: curUser.mobile,
        email: curUser.email,
        password: curUser.password
      }
    };

    var setUserInfo =  function(url) {
      if(!url || url.indexOf("{")<0) return url;
      let ret = url;
      ret = ret.replace("{userid}", curUser.id);
      ret = ret.replace("{usercode}", curUser.code);
      ret = ret.replace("{username}", curUser.name);
      ret = ret.replace("{loginname}", curUser.loginname);
      ret = ret.replace("{mobile}", curUser.mobile);
      ret = ret.replace("{email}", curUser.email);
      ret = ret.replace("{password}", curUser.password);
      return ret;
    };

    var getSubCategory = function(parent) {
      if(parent.subCategorys) {
        for(var i=0;i<parent.subCategorys.length;i++) {
          let subId = parent.subCategorys[i];
          let c = categoryModel.values[subId];
          ret.categorys[subId] = {
            id: c.id,
            name: c.name,
            icon_code: c.icon_code,
            order_no: c.order_no,
            subCategorys: c.subCategorys,
            apps: c.apps,
            status: c.status
          };
          getSubCategory(c);
        }
      }
      
      if(parent.apps) {
        for(var i=0;i<parent.apps.length;i++) {
          let appId = parent.apps[i];
          //如果已经添加，则忽略
          if(ret.apps[appId]) continue;

          var haveAuth = false;
          for(var j=0;j<auths.length;j++) {
            var auth = auths[j];
            if(auth.app_id==appId) {
              if(auth.owner_type=='user' && auth.owner_id==args.userId) {
                haveAuth = true;
                break;
              } else if(auth.owner_type=='dep' && curUser.deps.contains(auth.owner_id)) {
                haveAuth = true;
                break;
              } else if(auth.owner_type=='role' && (curUser.roles.contains(auth.owner_id) 
                || (roleAllUser && auth.owner_id==roleAllUser.id))) {
                haveAuth = true;
                break;
              }
            }
          }

          if(haveAuth) {
            let app = appModel.values[appId];
            if(app.status==0) {
              let appInfo = {
                app_id: appId,
                app_name: app.app_name,
                icon_path: app.icon_path,
                icon_code: app.icon_code,
                open_type: app.pc_open_type,
                order_no: app.order_no
              };
              if(args.clientType == 'phone') { 
                appInfo.url_phone = setUserInfo(app.url_phone);
                appInfo.url_phone_detail = setUserInfo(app.url_phone_detail);
                appInfo.get_badge_service = setUserInfo(app.get_badge_service);
                appInfo.titlebar_color = app.titlebar_color;
                appInfo.deploy = app.deploy;
              } else if(args.clientType == 'pad') { 
                appInfo.url_pad = setUserInfo(app.url_pad);
                appInfo.url_pad_detail = setUserInfo(app.url_pad_detail);
                appInfo.get_badge_service = setUserInfo(app.get_badge_service);
                appInfo.titlebar_color = app.titlebar_color;
                appInfo.deploy = app.deploy;
              } else if(args.clientType == 'pc') {
                appInfo.url_pc = setUserInfo(app.url_pc);
                appInfo.url_pc_detail = setUserInfo(app.url_pc_detail);
                appInfo.get_badge_service = setUserInfo(app.get_badge_service);
                appInfo.pc_open_type = app.pc_open_type;
              } else if(args.clientType == 'web') { 
                appInfo.url_web = setUserInfo(app.url_web);
                appInfo.get_badge_service = setUserInfo(app.get_badge_service);
                appInfo.open_type = app.pc_open_type;
              }
              ret.apps[appId] = appInfo;
            }
          }
        }
      }
    };

    getSubCategory(rootCategory);

    return ret;
  }, function(err, ret) {
  	if(err) {
  		console.log(err);
  		return;
  	}
    res.categorys = ret.categorys;
    res.subCategorys = ret.subCategorys;
    res.apps = ret.apps;
    
    //对应用进行排序
    let apps = [];
    if(!ret.appIds) ret.appIds = [];
    ret.appIds.forEach(appId => {
      let app = res.apps[appId];
      if(!app) return;
      apps.push(app);
    });
    apps.sort(utils.compare('order_no'));
    let appIds = [];
    apps.forEach(app => {
      appIds.push(app.app_id);
    });
    res.appIds = appIds;

    //清除应用分类中无效的应用编号
    var clearNullApp = function(category) {
      let arr = [];
      if(category.apps) {
        for(let i=0;i<category.apps.length;i++) {
          let appId = category.apps[i];
          if(res.apps[appId]) arr.push(appId);
        }
        category.apps = arr;
      }
      if(category.subCategorys) {
        for(let i=0;i<category.subCategorys.length;i++) {
          let categoryId = category.subCategorys[i];
          clearNullApp(res.categorys[categoryId]);
        }
      }
    };

    for(let categoryId in res.categorys) {
      clearNullApp(res.categorys[categoryId]);
    }

    self.end(res);
  });
};
