var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/vapp_auth');
var DaoC = require('../../dao/org_app_category');

/**
 * 获得当前用户可以访问的应用列表
 */
var GetMyAppList = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetMyAppList, Service);

module.exports = GetMyAppList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetMyAppList.prototype.process =  function(req, res) {
  if (server.config.Cache.type && server.config.Cache.type == 'taskmsg') {
    this.pipe(require('../../../system/service/app/getListUserApp'), req, res);
    return;
  }
  res.apps = [];
  res.categorys = [];

  var ctype = req.session.clientType.toLowerCase();

  if(req.clientType) ctype = req.clientType.toLowerCase();

  var clientType = 'web';
  if(ctype=='pc'){
    clientType = 'pc';
  } else if(ctype.indexOf('phone')>=0){
    clientType = 'phone';
  } else if(ctype.indexOf('pad')>=0){
    clientType = 'pad';
  }

  var self = this;

  req.session.cache.exec({
    userId: req.session.userId,
    clientType: clientType
  }, function(cacheData, args) {
    var curUser = cacheData['user'].values[args.userId];
    var roleAllUser = null;
    for(roleId in cacheData['role'].values) {
      var role = cacheData['role'].values[roleId];
      if(role.name=='所有人') {
        roleAllUser = role;
        break;
      }
    }
    
    var authsModel = cacheData['app_auth'];
    var auths = [];
    for(var j=0;j<authsModel.keys.length;j++) {
      var auth = authsModel.values[authsModel.keys[j]];
      if(!auth.opration_id && (!auth.terminal || auth.terminal.indexOf(args.clientType)>=0)) {
        auths.push({
          app_id: auth.app_id,
          owner_id: auth.owner_id,
          owner_type: auth.owner_type
        });
      }
    }

    var apps = [];
    var appKeys = cacheData['app'].keys;
    for(var i=0;i<appKeys.length;i++) {
      var app = cacheData['app'].values[appKeys[i]];
      var haveAuth = false;
      for(var j=0;j<auths.length;j++) {
        var auth = auths[j];
        if(auth.app_id==app.app_id) {
          if(auth.owner_type=='user' && auth.owner_id==args.userId) {
            haveAuth = true;
            break;
          } else if(auth.owner_type=='dep' && curUser.deps.contains(auth.owner_id)) {
            haveAuth = true;
            break;
          } else if(auth.owner_type=='role' && (curUser.roles.contains(auth.owner_id) 
            || (roleAllUser && auth.owner_id==roleAllUser.id))) {
            haveAuth = true;
            break;
          }
        }
      }
      if(haveAuth) {
        var appInfo = {
          app_id: app.app_id,
          app_code: app.app_code,
          app_name: app.app_name,
          icon_path: app.icon_path,
          icon_code: app.icon_code,
          category_id: app.category_id,
          msg_group: app.msg_group,
          order_no: app.order_no
        };

        if(args.clientType == 'phone') { 
          appInfo.url_phone = app.url_phone;
          appInfo.url_phone_detail = app.url_phone_detail;
          appInfo.titlebar_color = app.titlebar_color;
          appInfo.get_badge_service = app.get_badge_service;
          appInfo.deploy = app.deploy;
        } else if(args.clientType == 'pc') {
          appInfo.url_pc = app.url_pc;
          appInfo.url_pc_detail = app.url_pc_detail;
          appInfo.pc_show_on_sysbar = app.pc_show_on_sysbar;
          appInfo.pc_open_type = app.pc_open_type;
          appInfo.get_badge_service = app.get_badge_service;
        } else if(args.clientType == 'pad') { 
          appInfo.url_pad = app.url_pad;
          appInfo.url_pad_detail = app.url_pad_detail;
          appInfo.titlebar_color = app.titlebar_color;
          appInfo.get_badge_service = app.get_badge_service;
          appInfo.deploy = app.deploy;
        } else if(args.clientType == 'web') { 
          appInfo.url_web = app.url_web;
          appInfo.url_web_detail = app.url_web_detail;
          appInfo.pc_open_type = app.pc_open_type;
        }

        apps.push(appInfo);
      }
    }
    return {
      user: {
        id: curUser.id,
        code: curUser.code,
        name: curUser.name,
        loginname: curUser.loginname,
        mobile: curUser.mobile,
        email: curUser.email,
        password: curUser.password
      },
      apps: apps
    };
  }, function(err, ret) {
  	if(err) {
  		console.log(err);
  		return;
  	}
    res.apps = ret.apps;
    var cids = [];
    for(var i=0;i<res.apps.length;i++) {
      var app = res.apps[i];
      if(!cids.contains(app.category_id)) cids.push(app.category_id);
      //替换url中的用户信息，以便集成第三方系统
      if(app.url_phone) app.url_phone = self.setUserInfo(ret.user, app.url_phone);
      if(app.url_phone_detail) app.url_phone_detail = self.setUserInfo(ret.user, app.url_phone_detail);
      if(app.url_pc) app.url_pc = self.setUserInfo(ret.user, app.url_pc);
      if(app.url_pc_detail) app.url_pc_detail = self.setUserInfo(ret.user, app.url_pc_detail);
      if(app.url_pad) app.url_pad = self.setUserInfo(ret.user, app.url_pad);
      if(app.url_pad_detail) app.url_pad_detail = self.setUserInfo(ret.user, app.url_pad_detail);
      if(app.url_web) app.url_web = self.setUserInfo(ret.user, app.url_web);
      if(app.url_web_detail) app.url_web_detail = self.setUserInfo(ret.user, app.url_web_detail);
    }
    req.session.cache.getList("app_category", null, function(err, categorys) {
      res.categorys = [];
      let cdic = {};
      for(let i=0;i<categorys.length;i++) {
        let c = categorys[i];
        cdic[c.id] = c;
      }
      for(let i=0;i<cids.length;i++) {
        let c = cdic[cids[i]];
        self.setCategory(res, cdic, c);
      }
      res.categorys.sort(utils.compare('order_no'));
      self.end(res);
    });
  });
};

GetMyAppList.prototype.setCategory =  function(res, cdic, category) {
  if(!category) return;
  if(category.parent_id!=0) {
    let parent = cdic[category.parent_id];
    if(parent) this.setCategory(res, cdic, parent);
  }
  let isAdd = false;
  for(let i=0;i<res.categorys.length;i++) {
    if(res.categorys[i].id==category.id) {
      isAdd = true;
      break;
    }
  }
  if(!isAdd) res.categorys.push(category);
};

GetMyAppList.prototype.setUserInfo =  function(user, url) {
  if(!url || url.indexOf("{")<0) return url;
  let ret = url;
  ret = ret.replace("{userid}", user.id);
  ret = ret.replace("{usercode}", user.code);
  ret = ret.replace("{username}", user.name);
  ret = ret.replace("{loginname}", user.loginname);
  ret = ret.replace("{mobile}", user.mobile);
  ret = ret.replace("{email}", user.email);
  ret = ret.replace("{password}", user.password);
  return ret;
};
