var Service = require('Service');
var util = require('util');
var Dao = require('../../dao/vapp_auth');

/**
 * 获得当前用户可以访问的应用列表
 */
var GetMyApp = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetMyApp, Service);

module.exports = GetMyApp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetMyApp.prototype.process =  function(req, res) {
  if(!req.appId) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }

  var clientType = '手机';
  var authTerminal = '("all","mobile")';
  if(req.session.clientType=='pc'){
    clientType = '电脑';
    authTerminal = '("all","pcc")';
  }else if(req.session.clientType=='web'){
    clientType = '管理';
    authTerminal = '("all","pc")';
  }
  if(req.session.clientType.toLowerCase().indexOf('pad')>0) clientType = '平板';

  /*var a = req.session.org.apps[parseInt(req.appId)];
  if(!a) {
    this.onLogicError(2, '应用不存在！');
    return;
  }

  if(a.status!=0 || a.terminal.indexOf(clientType)<0) {
    this.onLogicError(3, '未找到符合条件的应用！');
    return;
  }

  var appInfo = {};
  appInfo['app_id'] = a['id'];
  appInfo['app_code'] = a['code'];
  appInfo['app_name'] = a['name'];
  appInfo['icon_path'] = a['icon_path'];
  appInfo['icon_code'] = a['icon_code'];
  appInfo['url_phone'] = a['url_phone'];
  appInfo['url_phone_detail'] = a['url_phone_detail'];
  res.app = appInfo;
  this.end(res);*/

  var self = this;
  var where = 'org_id='+req.session.orgId+' and status=0 and app_id='
    +req.appId+' and (opration_id is null or opration_id=0) and auth_terminal in'+authTerminal
    +' and terminal like \'%'+clientType+'%\' and '
    +'((owner_type=\'角色\' and owner_id in (select role_id from sys_role_user '
    +'where org_id='+req.session.orgId+' and user_id='+req.session.userId+')) or '
    +'(owner_type=\'部门\' and owner_id in (select dep_id from sys_dep_user '
    +'where org_id='+req.session.orgId+' and user_id='+req.session.userId+')) or '
    +'(owner_type=\'用户\' and owner_id='+req.session.userId+'))';
  if(req.categoryId) where += ' and category_id='+req.categoryId;
  var fields = 'app_id,app_name,icon_path,icon_code,url_phone,url_pad,'
    +'url_phone_detail,url_pad_detail';
  // if(clientType = '手机') {
  //   fields += ',url_phone';
  // } else if(clientType = '平板') {
  //   fields += ',url_pad';
  // } else {
  //   fields += ',url_pc';
  // }
  var dao = new Dao(this);
  dao.query({fields: fields, distinct: true, where: where}, function(rows) { 	
    res.app = {};
    if(rows.length>0) res.app = rows[0];
    self.end(res);
  });
};