var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/vorg_app');

/**
 * 获得应用列表
 */
var GetAppList = function() { 
  Service.call(this);
};

util.inherits(GetAppList, Service);

module.exports = GetAppList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetAppList.prototype.process =  function(req, res) {
  var self = this;
  var params = [];
  var where = 'org_id='+req.session.orgId;
  var status = '';
  if(req.categoryId) {
    where += ' and category_id=?';
    params.push(req.categoryId);
  }
  if(req.yymc){
    where += ' and (app_name like ?)';
    params.push('%'+req.yymc+'%');
  }
  if(req.zd){
    where += ' and (terminal like ?)';
    params.push('%'+req.zd+'%');
  }
  if(req.zt){
    if(req.zt == '正常'){
      status = '0';
    }
    if(req.zt == '已禁用'){
      status = '1';
    }
    where += ' and status=\''+status+'\'';
  }
  var dao = new Dao(this);
  dao.queryDataPage(req, {where: where, order: 'order_no asc,app_id asc', params: params}, 
    function(dataPage) {
    res.dataPage = dataPage;
    self.end(res);
  });
};