var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/org_app_category');

/**
 * 获得分类列表
 */
var GetAppCategorys = function() { 
  Service.call(this);
  this.enableTransaction = false;
  this.checkAuthority = false;
};

util.inherits(GetAppCategorys, Service);

module.exports = GetAppCategorys;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetAppCategorys.prototype.process =  function(req, res) {
	var self = this;
  var where = 'org_id='+req.session.orgId;
  if(req.excludeId) {
    var excludeIds = utils.strToIntArray(req.excludeId);
    if(excludeIds.length>0) {
      excludeIds = excludeIds.join();
      where += ' and id not in ('+excludeIds+') and parent_id not in ('+excludeIds+')';
    }
  }
  var dao = new Dao(this);
  dao.query({where: where, order: 'order_no asc'}, function(rows) { 	
    res.categorys = rows;
    self.end(res);
  });
};