var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Daos = require('Dao');
var Dao = require('../../dao/org_app_category');
var AttachDao = require('../../dao/app_attach');

/**
 * 获得应用分类
 */
var GetAppCategory = function() { 
  Service.call(this);
  this.enableTransaction = false;
  this.checkAuthority = false;
  this._dao = new Daos(this);
};

util.inherits(GetAppCategory, Service);

module.exports = GetAppCategory;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetAppCategory.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供类别编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的类别编号！');
    return;
  }

  var self = this;
  self._dao.execute(
  "select *,(select name from sys_org_app_category where sys_org_app_category.id = a.parent_id) as parentName "
  +"from sys_org_app_category a where org_id = "+req.session.orgId+" and id = "+req.id, null,
  function(rows) {
  // var dao = new Dao(this);
  // dao.query({fields: '*,(select name from sys_org_app_category where parent_id = id) as parentName',where: 'org_id='+req.session.orgId+' and id='+req.id}, function(rows) { 	
    if(rows.length==0) {
      self.onLogicError(2, '该类别不存在！');
      return;
    }
    res.category = rows[0];
    req.excludeId = req.id;
    if(!res.category.icon_code) {
      self.pipe(require('./getCategorys'), req, res);
      return;
    }
    var daoAttach = new AttachDao(self);
    daoAttach.query({fields:'code,name,id,size', where:'org_id='
      +req.session.orgId+' and code=\''+res.category.icon_code
      +'\' and app_code=\'app_category_icon\''}, function(rows2) {
      if(rows2.length>0) res.category.icon = rows2[0];
      self.pipe(require('./getCategorys'), req, res);
    });
  });
};