var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/vapp_auth');

/**
 * 获得应用权限列表
 */
var GetAuthList = function() { 
  Service.call(this);
};

util.inherits(GetAuthList, Service);

module.exports = GetAuthList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetAuthList.prototype.process =  function(req, res) {
  if(!req.appId) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if(!utils.isInt(req.appId)) {
    this.onLogicError(3, '请提供正确的应用编号！');
    return;
  }

  var self = this;
  var dao = new Dao(this);
  var where = '';
  var params = [];
  if(req.owner_type){
    where = ' and owner_type=?';
    params.push(req.owner_type);
  }
  if(req.owner_name){
    where = ' and owner_name=?';
    params.push(req.owner_name);
  }
  if(req.auth_terminal){
    where = ' and auth_terminal=?';
    params.push(req.auth_terminal);
  }
  dao.queryDataPage(req, 
  	{distinct: true, 
      fields: 'id,owner_id,owner_type,owner_name,opration_name,auth_terminal',
      where: 'org_id='+req.session.orgId+' and app_id='+req.appId+where,
      order: 'owner_type asc,owner_id asc',
      params: params
    }, 
  	function(dataPage) { 	
    res.dataPage = dataPage;
    self.end(res);
  });
};