var util = require('util');
var Service = require('Service');
var AttachDao = require('../../dao/app_attach');
var utils = require('utils');

/**
 * 获得附件列表
 */
var GetAttachList = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(GetAttachList, Service);

module.exports = GetAttachList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
GetAttachList.prototype.process =  function(req, res) {
  if(!req.appCode) {
    this.onLogicError(1, '请提供应用代码！');
    return;
  }
  var where = 'app_code=? and org_id=?';
  var params = [req.appCode, req.session.orgId];
  if(req.appDataId) {
    where += ' and app_data_id=?';
    params.push(req.appDataId);
  }
  console.log(where);
  var self = this;
  var attachDao = new AttachDao(this);
  attachDao.query({
    fields: 'id,code,name,size,type,uploader_id,uploader_name,upload_time',
    where: where,
    params: params
  }, function(rows) {
    res.attachList = rows;
    self.emit('end', res);
  });
};