var Service = require('Service');
var utils = require('utils');
var util = require('util');
var Dao = require('../../dao/vorg_app');
var AttachDao = require('../../dao/app_attach');

/**
 * 获得应用信息
 */
var Get = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(Get, Service);

module.exports = Get;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
Get.prototype.process =  function(req, res) {
  if(!req.id) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if(!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的应用编号！');
    return;
  }

  var self = this;
  var dao = new Dao(this);
  dao.query({where: 'org_id='+req.session.orgId+' and app_id='+req.id}, function(rows) { 	
    if(rows.length==0) {
      self.onLogicError(3, '该应用不存在！');
      return;
    }
    res.app = rows[0];

    var daoAttach = new AttachDao(self);
    daoAttach.query({fields:'code,name,id,size', where:'org_id='
      +req.session.orgId+' and code=\''+res.app.icon_code
      +'\' and app_code=\'app_icon\''}, function(rows2) {
      if(rows2.length>0) res.app.app_icon = rows2[0];
      self.pipe(require('./getCategorys'), req, res);
    });
  });
};